/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.consumer.adapters;

import java.io.File;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.camel.support.resume.Resumables;

public final class DirectoryEntries {
    private final File directory;
    private final File[] inputFiles;
    private File[] outputFiles;

    public DirectoryEntries(File directory, File[] inputFiles) {
        this.directory = directory;
        this.inputFiles = Objects.requireNonNull(inputFiles, "A list of input files must be provided for the resume info");
    }

    public File[] resumed() {
        return this.outputFiles;
    }

    public boolean hasResumables() {
        return this.outputFiles != this.inputFiles;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setOutputFiles(File[] resumed) {
        this.outputFiles = resumed;
    }

    public static void doResume(DirectoryEntries directoryEntries, Predicate<File> resumableCheck) {
        File[] processed = (File[])Resumables.resumeEach((Object[])directoryEntries.inputFiles, resumableCheck);
        directoryEntries.setOutputFiles(processed);
    }
}

