/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir.api;

import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.PreferReturnEnum;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.IUpdateExecutable;
import ca.uhn.fhir.rest.gclient.IUpdateTyped;
import java.util.Map;
import org.apache.camel.component.fhir.api.ExtraParameters;
import org.apache.camel.util.ObjectHelper;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class FhirUpdate {
    private final IGenericClient client;

    public FhirUpdate(IGenericClient client) {
        this.client = client;
    }

    public MethodOutcome resource(IBaseResource resource, IIdType id, PreferReturnEnum preferReturn, Map<ExtraParameters, Object> extraParameters) {
        IUpdateTyped updateTyped = this.client.update().resource(resource);
        IUpdateExecutable updateExecutable = this.withOptionalId(id, updateTyped);
        ExtraParameters.process(extraParameters, updateExecutable);
        return this.processOptionalParam(preferReturn, updateExecutable);
    }

    public MethodOutcome resource(String resourceAsString, IIdType id, PreferReturnEnum preferReturn, Map<ExtraParameters, Object> extraParameters) {
        IUpdateTyped updateTyped = this.client.update().resource(resourceAsString);
        IUpdateExecutable updateExecutable = this.withOptionalId(id, updateTyped);
        ExtraParameters.process(extraParameters, updateExecutable);
        return this.processOptionalParam(preferReturn, updateExecutable);
    }

    public MethodOutcome resource(IBaseResource resource, String stringId, PreferReturnEnum preferReturn, Map<ExtraParameters, Object> extraParameters) {
        IUpdateTyped updateTyped = this.client.update().resource(resource);
        IUpdateExecutable updateExecutable = this.withOptionalId(stringId, updateTyped);
        ExtraParameters.process(extraParameters, updateExecutable);
        return this.processOptionalParam(preferReturn, updateExecutable);
    }

    public MethodOutcome resource(String resourceAsString, String stringId, PreferReturnEnum preferReturn, Map<ExtraParameters, Object> extraParameters) {
        IUpdateTyped updateTyped = this.client.update().resource(resourceAsString);
        IUpdateExecutable updateExecutable = this.withOptionalId(stringId, updateTyped);
        ExtraParameters.process(extraParameters, updateExecutable);
        return this.processOptionalParam(preferReturn, updateExecutable);
    }

    public MethodOutcome resourceBySearchUrl(IBaseResource resource, String url, PreferReturnEnum preferReturn, Map<ExtraParameters, Object> extraParameters) {
        IUpdateTyped updateExecutable = this.client.update().resource(resource).conditionalByUrl(url);
        ExtraParameters.process(extraParameters, updateExecutable);
        return this.processOptionalParam(preferReturn, (IUpdateExecutable)updateExecutable);
    }

    public MethodOutcome resourceBySearchUrl(String resourceAsString, String url, PreferReturnEnum preferReturn, Map<ExtraParameters, Object> extraParameters) {
        IUpdateTyped updateExecutable = this.client.update().resource(resourceAsString).conditionalByUrl(url);
        ExtraParameters.process(extraParameters, updateExecutable);
        return this.processOptionalParam(preferReturn, (IUpdateExecutable)updateExecutable);
    }

    private MethodOutcome processOptionalParam(PreferReturnEnum preferReturn, IUpdateExecutable updateExecutable) {
        if (preferReturn != null) {
            return (MethodOutcome)updateExecutable.prefer(preferReturn).execute();
        }
        return (MethodOutcome)updateExecutable.execute();
    }

    private IUpdateExecutable withOptionalId(IIdType id, IUpdateTyped updateTyped) {
        if (ObjectHelper.isNotEmpty((Object)id)) {
            return updateTyped.withId(id);
        }
        return updateTyped;
    }

    private IUpdateExecutable withOptionalId(String stringId, IUpdateTyped updateTyped) {
        if (ObjectHelper.isNotEmpty((String)stringId)) {
            return updateTyped.withId(stringId);
        }
        return updateTyped;
    }
}

