/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.exec;

import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.exec.ExecResult;
import org.apache.camel.component.exec.ExecResultConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.w3c.dom.Document;

@DeferredContextBinding
public final class ExecResultConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        ExecResultConverterLoader.addTypeConverter(registry, byte[].class, ExecResult.class, false, (type, exchange, value) -> ExecResultConverter.convertToByteArray((ExecResult)value, exchange));
        ExecResultConverterLoader.addTypeConverter(registry, InputStream.class, ExecResult.class, false, (type, exchange, value) -> ExecResultConverter.convertToInputStream((ExecResult)value));
        ExecResultConverterLoader.addTypeConverter(registry, String.class, ExecResult.class, false, (type, exchange, value) -> ExecResultConverter.convertToString((ExecResult)value, exchange));
        ExecResultConverterLoader.addTypeConverter(registry, Document.class, ExecResult.class, false, (type, exchange, value) -> ExecResultConverter.convertToDocument((ExecResult)value, exchange));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

