/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint.dsl;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.ssl.SslHandler;
import java.util.Map;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.component.netty.ClientInitializerFactory;
import org.apache.camel.component.netty.NettyServerBootstrapFactory;
import org.apache.camel.component.netty.ServerInitializerFactory;
import org.apache.camel.component.netty.http.NettyHttpBinding;
import org.apache.camel.component.netty.http.NettyHttpConfiguration;
import org.apache.camel.component.netty.http.NettyHttpSecurityConfiguration;
import org.apache.camel.component.netty.http.NettySharedHttpServer;
import org.apache.camel.http.base.cookie.CookieHandler;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.jsse.SSLContextParameters;

public interface NettyHttpEndpointBuilderFactory {
    public static NettyHttpEndpointBuilder endpointBuilder(String componentName, String path) {
        class NettyHttpEndpointBuilderImpl
        extends AbstractEndpointBuilder
        implements NettyHttpEndpointBuilder,
        AdvancedNettyHttpEndpointBuilder {
            final /* synthetic */ String val$componentName;

            public NettyHttpEndpointBuilderImpl(String path, String string) {
                this.val$componentName = string;
                super(string, path);
            }
        }
        return new NettyHttpEndpointBuilderImpl(path, componentName);
    }

    public static class NettyHttpHeaderNameBuilder {
        private static final NettyHttpHeaderNameBuilder INSTANCE = new NettyHttpHeaderNameBuilder();

        public String httpAuthentication() {
            return "CamelHttpAuthentication";
        }

        public String contentType() {
            return "Content-Type";
        }

        public String connection() {
            return "connection";
        }

        public String nettyCloseChannelWhenComplete() {
            return "CamelNettyCloseChannelWhenComplete";
        }

        public String httpResponseCode() {
            return "CamelHttpResponseCode";
        }

        public String httpProtocolVersion() {
            return "CamelHttpProtocolVersion";
        }

        public String httpMethod() {
            return "CamelHttpMethod";
        }

        public String httpQuery() {
            return "CamelHttpQuery";
        }

        public String httpPath() {
            return "CamelHttpPath";
        }

        public String httpRawQuery() {
            return "CamelHttpRawQuery";
        }

        public String httpUrl() {
            return "CamelHttpUrl";
        }

        public String httpCharacterEncoding() {
            return "CamelHttpCharacterEncoding";
        }

        public String httpUri() {
            return "CamelHttpUri";
        }

        public String nettyChannelHandlerContext() {
            return "CamelNettyChannelHandlerContext";
        }

        public String nettyRemoteAddress() {
            return "CamelNettyRemoteAddress";
        }

        public String nettyLocalAddress() {
            return "CamelNettyLocalAddress";
        }

        public String nettySSLSession() {
            return "CamelNettySSLSession";
        }

        public String nettySSLClientCertSubjectName() {
            return "CamelNettySSLClientCertSubjectName";
        }

        public String nettySSLClientCertIssuerName() {
            return "CamelNettySSLClientCertIssuerName";
        }

        public String nettySSLClientCertSerialNumber() {
            return "CamelNettySSLClientCertSerialNumber";
        }

        public String nettySSLClientCertNotBefore() {
            return "CamelNettySSLClientCertNotBefore";
        }

        public String nettySSLClientCertNotAfter() {
            return "CamelNettySSLClientCertNotAfter";
        }

        public String nettyRequestTimeout() {
            return "CamelNettyRequestTimeout";
        }

        public String nettyChannel() {
            return "CamelNettyChannel";
        }
    }

    public static interface NettyHttpBuilders {
        default public NettyHttpHeaderNameBuilder nettyHttp() {
            return NettyHttpHeaderNameBuilder.INSTANCE;
        }

        default public NettyHttpEndpointBuilder nettyHttp(String path) {
            return NettyHttpEndpointBuilderFactory.endpointBuilder("netty-http", path);
        }

        default public NettyHttpEndpointBuilder nettyHttp(String componentName, String path) {
            return NettyHttpEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    public static interface AdvancedNettyHttpEndpointBuilder
    extends AdvancedNettyHttpEndpointConsumerBuilder,
    AdvancedNettyHttpEndpointProducerBuilder {
        @Override
        default public NettyHttpEndpointBuilder basic() {
            return (NettyHttpEndpointBuilder)((Object)this);
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder allowSerializedHeaders(boolean allowSerializedHeaders) {
            this.doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder allowSerializedHeaders(String allowSerializedHeaders) {
            this.doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder channelGroup(ChannelGroup channelGroup) {
            this.doSetProperty("channelGroup", channelGroup);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder channelGroup(String channelGroup) {
            this.doSetProperty("channelGroup", channelGroup);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder configuration(NettyHttpConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder configuration(String configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder disableStreamCache(boolean disableStreamCache) {
            this.doSetProperty("disableStreamCache", disableStreamCache);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder disableStreamCache(String disableStreamCache) {
            this.doSetProperty("disableStreamCache", disableStreamCache);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder headerFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
            this.doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder headerFilterStrategy(String headerFilterStrategy) {
            this.doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder nativeTransport(boolean nativeTransport) {
            this.doSetProperty("nativeTransport", nativeTransport);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder nativeTransport(String nativeTransport) {
            this.doSetProperty("nativeTransport", nativeTransport);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder nettyHttpBinding(NettyHttpBinding nettyHttpBinding) {
            this.doSetProperty("nettyHttpBinding", nettyHttpBinding);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder nettyHttpBinding(String nettyHttpBinding) {
            this.doSetProperty("nettyHttpBinding", nettyHttpBinding);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder options(String key, Object value) {
            this.doSetMultiValueProperty("options", "option." + key, value);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder options(Map values) {
            this.doSetMultiValueProperties("options", "option.", values);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder receiveBufferSize(int receiveBufferSize) {
            this.doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder receiveBufferSize(String receiveBufferSize) {
            this.doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder receiveBufferSizePredictor(int receiveBufferSizePredictor) {
            this.doSetProperty("receiveBufferSizePredictor", receiveBufferSizePredictor);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder receiveBufferSizePredictor(String receiveBufferSizePredictor) {
            this.doSetProperty("receiveBufferSizePredictor", receiveBufferSizePredictor);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder sendBufferSize(int sendBufferSize) {
            this.doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder sendBufferSize(String sendBufferSize) {
            this.doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder shutdownTimeout(int shutdownTimeout) {
            this.doSetProperty("shutdownTimeout", shutdownTimeout);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder shutdownTimeout(String shutdownTimeout) {
            this.doSetProperty("shutdownTimeout", shutdownTimeout);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder synchronous(boolean synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder synchronous(String synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder transferException(boolean transferException) {
            this.doSetProperty("transferException", transferException);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder transferException(String transferException) {
            this.doSetProperty("transferException", transferException);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder transferExchange(boolean transferExchange) {
            this.doSetProperty("transferExchange", transferExchange);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder transferExchange(String transferExchange) {
            this.doSetProperty("transferExchange", transferExchange);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder unixDomainSocketPath(String unixDomainSocketPath) {
            this.doSetProperty("unixDomainSocketPath", unixDomainSocketPath);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder workerCount(int workerCount) {
            this.doSetProperty("workerCount", workerCount);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder workerCount(String workerCount) {
            this.doSetProperty("workerCount", workerCount);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder workerGroup(EventLoopGroup workerGroup) {
            this.doSetProperty("workerGroup", workerGroup);
            return this;
        }

        @Override
        default public AdvancedNettyHttpEndpointBuilder workerGroup(String workerGroup) {
            this.doSetProperty("workerGroup", workerGroup);
            return this;
        }
    }

    public static interface NettyHttpEndpointBuilder
    extends NettyHttpEndpointConsumerBuilder,
    NettyHttpEndpointProducerBuilder {
        @Override
        default public AdvancedNettyHttpEndpointBuilder advanced() {
            return (AdvancedNettyHttpEndpointBuilder)((Object)this);
        }

        @Override
        default public NettyHttpEndpointBuilder bridgeEndpoint(boolean bridgeEndpoint) {
            this.doSetProperty("bridgeEndpoint", bridgeEndpoint);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder bridgeEndpoint(String bridgeEndpoint) {
            this.doSetProperty("bridgeEndpoint", bridgeEndpoint);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder disconnect(boolean disconnect) {
            this.doSetProperty("disconnect", disconnect);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder disconnect(String disconnect) {
            this.doSetProperty("disconnect", disconnect);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder keepAlive(boolean keepAlive) {
            this.doSetProperty("keepAlive", keepAlive);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder keepAlive(String keepAlive) {
            this.doSetProperty("keepAlive", keepAlive);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder reuseAddress(boolean reuseAddress) {
            this.doSetProperty("reuseAddress", reuseAddress);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder reuseAddress(String reuseAddress) {
            this.doSetProperty("reuseAddress", reuseAddress);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder reuseChannel(boolean reuseChannel) {
            this.doSetProperty("reuseChannel", reuseChannel);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder reuseChannel(String reuseChannel) {
            this.doSetProperty("reuseChannel", reuseChannel);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder sync(boolean sync) {
            this.doSetProperty("sync", sync);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder sync(String sync) {
            this.doSetProperty("sync", sync);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder tcpNoDelay(boolean tcpNoDelay) {
            this.doSetProperty("tcpNoDelay", tcpNoDelay);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder tcpNoDelay(String tcpNoDelay) {
            this.doSetProperty("tcpNoDelay", tcpNoDelay);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder decoders(String decoders) {
            this.doSetProperty("decoders", decoders);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder encoders(String encoders) {
            this.doSetProperty("encoders", encoders);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder enabledProtocols(String enabledProtocols) {
            this.doSetProperty("enabledProtocols", enabledProtocols);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder hostnameVerification(boolean hostnameVerification) {
            this.doSetProperty("hostnameVerification", hostnameVerification);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder hostnameVerification(String hostnameVerification) {
            this.doSetProperty("hostnameVerification", hostnameVerification);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder keyStoreFormat(String keyStoreFormat) {
            this.doSetProperty("keyStoreFormat", keyStoreFormat);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder keyStoreResource(String keyStoreResource) {
            this.doSetProperty("keyStoreResource", keyStoreResource);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder passphrase(String passphrase) {
            this.doSetProperty("passphrase", passphrase);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder securityProvider(String securityProvider) {
            this.doSetProperty("securityProvider", securityProvider);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder ssl(boolean ssl) {
            this.doSetProperty("ssl", ssl);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder ssl(String ssl) {
            this.doSetProperty("ssl", ssl);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder sslClientCertHeaders(boolean sslClientCertHeaders) {
            this.doSetProperty("sslClientCertHeaders", sslClientCertHeaders);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder sslClientCertHeaders(String sslClientCertHeaders) {
            this.doSetProperty("sslClientCertHeaders", sslClientCertHeaders);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder sslContextParameters(SSLContextParameters sslContextParameters) {
            this.doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder sslContextParameters(String sslContextParameters) {
            this.doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder sslHandler(SslHandler sslHandler) {
            this.doSetProperty("sslHandler", sslHandler);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder sslHandler(String sslHandler) {
            this.doSetProperty("sslHandler", sslHandler);
            return this;
        }

        @Override
        default public NettyHttpEndpointBuilder trustStoreResource(String trustStoreResource) {
            this.doSetProperty("trustStoreResource", trustStoreResource);
            return this;
        }
    }

    public static interface AdvancedNettyHttpEndpointProducerBuilder
    extends EndpointProducerBuilder {
        default public NettyHttpEndpointProducerBuilder basic() {
            return (NettyHttpEndpointProducerBuilder)((Object)this);
        }

        default public AdvancedNettyHttpEndpointProducerBuilder clientInitializerFactory(ClientInitializerFactory clientInitializerFactory) {
            this.doSetProperty("clientInitializerFactory", clientInitializerFactory);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder clientInitializerFactory(String clientInitializerFactory) {
            this.doSetProperty("clientInitializerFactory", clientInitializerFactory);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder lazyChannelCreation(boolean lazyChannelCreation) {
            this.doSetProperty("lazyChannelCreation", lazyChannelCreation);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder lazyChannelCreation(String lazyChannelCreation) {
            this.doSetProperty("lazyChannelCreation", lazyChannelCreation);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder okStatusCodeRange(String okStatusCodeRange) {
            this.doSetProperty("okStatusCodeRange", okStatusCodeRange);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder producerPoolBlockWhenExhausted(boolean producerPoolBlockWhenExhausted) {
            this.doSetProperty("producerPoolBlockWhenExhausted", producerPoolBlockWhenExhausted);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder producerPoolBlockWhenExhausted(String producerPoolBlockWhenExhausted) {
            this.doSetProperty("producerPoolBlockWhenExhausted", producerPoolBlockWhenExhausted);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder producerPoolEnabled(boolean producerPoolEnabled) {
            this.doSetProperty("producerPoolEnabled", producerPoolEnabled);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder producerPoolEnabled(String producerPoolEnabled) {
            this.doSetProperty("producerPoolEnabled", producerPoolEnabled);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder producerPoolMaxIdle(int producerPoolMaxIdle) {
            this.doSetProperty("producerPoolMaxIdle", producerPoolMaxIdle);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder producerPoolMaxIdle(String producerPoolMaxIdle) {
            this.doSetProperty("producerPoolMaxIdle", producerPoolMaxIdle);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder producerPoolMaxTotal(int producerPoolMaxTotal) {
            this.doSetProperty("producerPoolMaxTotal", producerPoolMaxTotal);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder producerPoolMaxTotal(String producerPoolMaxTotal) {
            this.doSetProperty("producerPoolMaxTotal", producerPoolMaxTotal);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder producerPoolMaxWait(long producerPoolMaxWait) {
            this.doSetProperty("producerPoolMaxWait", producerPoolMaxWait);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder producerPoolMaxWait(String producerPoolMaxWait) {
            this.doSetProperty("producerPoolMaxWait", producerPoolMaxWait);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder producerPoolMinEvictableIdle(long producerPoolMinEvictableIdle) {
            this.doSetProperty("producerPoolMinEvictableIdle", producerPoolMinEvictableIdle);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder producerPoolMinEvictableIdle(String producerPoolMinEvictableIdle) {
            this.doSetProperty("producerPoolMinEvictableIdle", producerPoolMinEvictableIdle);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder producerPoolMinIdle(int producerPoolMinIdle) {
            this.doSetProperty("producerPoolMinIdle", producerPoolMinIdle);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder producerPoolMinIdle(String producerPoolMinIdle) {
            this.doSetProperty("producerPoolMinIdle", producerPoolMinIdle);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder useRelativePath(boolean useRelativePath) {
            this.doSetProperty("useRelativePath", useRelativePath);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder useRelativePath(String useRelativePath) {
            this.doSetProperty("useRelativePath", useRelativePath);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder allowSerializedHeaders(boolean allowSerializedHeaders) {
            this.doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder allowSerializedHeaders(String allowSerializedHeaders) {
            this.doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder channelGroup(ChannelGroup channelGroup) {
            this.doSetProperty("channelGroup", channelGroup);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder channelGroup(String channelGroup) {
            this.doSetProperty("channelGroup", channelGroup);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder configuration(NettyHttpConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder configuration(String configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder disableStreamCache(boolean disableStreamCache) {
            this.doSetProperty("disableStreamCache", disableStreamCache);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder disableStreamCache(String disableStreamCache) {
            this.doSetProperty("disableStreamCache", disableStreamCache);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder headerFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
            this.doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder headerFilterStrategy(String headerFilterStrategy) {
            this.doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder nativeTransport(boolean nativeTransport) {
            this.doSetProperty("nativeTransport", nativeTransport);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder nativeTransport(String nativeTransport) {
            this.doSetProperty("nativeTransport", nativeTransport);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder nettyHttpBinding(NettyHttpBinding nettyHttpBinding) {
            this.doSetProperty("nettyHttpBinding", nettyHttpBinding);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder nettyHttpBinding(String nettyHttpBinding) {
            this.doSetProperty("nettyHttpBinding", nettyHttpBinding);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder options(String key, Object value) {
            this.doSetMultiValueProperty("options", "option." + key, value);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder options(Map values) {
            this.doSetMultiValueProperties("options", "option.", values);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder receiveBufferSize(int receiveBufferSize) {
            this.doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder receiveBufferSize(String receiveBufferSize) {
            this.doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder receiveBufferSizePredictor(int receiveBufferSizePredictor) {
            this.doSetProperty("receiveBufferSizePredictor", receiveBufferSizePredictor);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder receiveBufferSizePredictor(String receiveBufferSizePredictor) {
            this.doSetProperty("receiveBufferSizePredictor", receiveBufferSizePredictor);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder sendBufferSize(int sendBufferSize) {
            this.doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder sendBufferSize(String sendBufferSize) {
            this.doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder shutdownTimeout(int shutdownTimeout) {
            this.doSetProperty("shutdownTimeout", shutdownTimeout);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder shutdownTimeout(String shutdownTimeout) {
            this.doSetProperty("shutdownTimeout", shutdownTimeout);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder synchronous(boolean synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder synchronous(String synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder transferException(boolean transferException) {
            this.doSetProperty("transferException", transferException);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder transferException(String transferException) {
            this.doSetProperty("transferException", transferException);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder transferExchange(boolean transferExchange) {
            this.doSetProperty("transferExchange", transferExchange);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder transferExchange(String transferExchange) {
            this.doSetProperty("transferExchange", transferExchange);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder unixDomainSocketPath(String unixDomainSocketPath) {
            this.doSetProperty("unixDomainSocketPath", unixDomainSocketPath);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder workerCount(int workerCount) {
            this.doSetProperty("workerCount", workerCount);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder workerCount(String workerCount) {
            this.doSetProperty("workerCount", workerCount);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder workerGroup(EventLoopGroup workerGroup) {
            this.doSetProperty("workerGroup", workerGroup);
            return this;
        }

        default public AdvancedNettyHttpEndpointProducerBuilder workerGroup(String workerGroup) {
            this.doSetProperty("workerGroup", workerGroup);
            return this;
        }
    }

    public static interface NettyHttpEndpointProducerBuilder
    extends EndpointProducerBuilder {
        default public AdvancedNettyHttpEndpointProducerBuilder advanced() {
            return (AdvancedNettyHttpEndpointProducerBuilder)((Object)this);
        }

        default public NettyHttpEndpointProducerBuilder bridgeEndpoint(boolean bridgeEndpoint) {
            this.doSetProperty("bridgeEndpoint", bridgeEndpoint);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder bridgeEndpoint(String bridgeEndpoint) {
            this.doSetProperty("bridgeEndpoint", bridgeEndpoint);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder disconnect(boolean disconnect) {
            this.doSetProperty("disconnect", disconnect);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder disconnect(String disconnect) {
            this.doSetProperty("disconnect", disconnect);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder keepAlive(boolean keepAlive) {
            this.doSetProperty("keepAlive", keepAlive);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder keepAlive(String keepAlive) {
            this.doSetProperty("keepAlive", keepAlive);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder reuseAddress(boolean reuseAddress) {
            this.doSetProperty("reuseAddress", reuseAddress);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder reuseAddress(String reuseAddress) {
            this.doSetProperty("reuseAddress", reuseAddress);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder reuseChannel(boolean reuseChannel) {
            this.doSetProperty("reuseChannel", reuseChannel);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder reuseChannel(String reuseChannel) {
            this.doSetProperty("reuseChannel", reuseChannel);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder sync(boolean sync) {
            this.doSetProperty("sync", sync);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder sync(String sync) {
            this.doSetProperty("sync", sync);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder tcpNoDelay(boolean tcpNoDelay) {
            this.doSetProperty("tcpNoDelay", tcpNoDelay);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder tcpNoDelay(String tcpNoDelay) {
            this.doSetProperty("tcpNoDelay", tcpNoDelay);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder connectTimeout(int connectTimeout) {
            this.doSetProperty("connectTimeout", connectTimeout);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder connectTimeout(String connectTimeout) {
            this.doSetProperty("connectTimeout", connectTimeout);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder cookieHandler(CookieHandler cookieHandler) {
            this.doSetProperty("cookieHandler", cookieHandler);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder cookieHandler(String cookieHandler) {
            this.doSetProperty("cookieHandler", cookieHandler);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder requestTimeout(long requestTimeout) {
            this.doSetProperty("requestTimeout", requestTimeout);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder requestTimeout(String requestTimeout) {
            this.doSetProperty("requestTimeout", requestTimeout);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder throwExceptionOnFailure(boolean throwExceptionOnFailure) {
            this.doSetProperty("throwExceptionOnFailure", throwExceptionOnFailure);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder throwExceptionOnFailure(String throwExceptionOnFailure) {
            this.doSetProperty("throwExceptionOnFailure", throwExceptionOnFailure);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder decoders(String decoders) {
            this.doSetProperty("decoders", decoders);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder encoders(String encoders) {
            this.doSetProperty("encoders", encoders);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder enabledProtocols(String enabledProtocols) {
            this.doSetProperty("enabledProtocols", enabledProtocols);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder hostnameVerification(boolean hostnameVerification) {
            this.doSetProperty("hostnameVerification", hostnameVerification);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder hostnameVerification(String hostnameVerification) {
            this.doSetProperty("hostnameVerification", hostnameVerification);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder keyStoreFormat(String keyStoreFormat) {
            this.doSetProperty("keyStoreFormat", keyStoreFormat);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder keyStoreResource(String keyStoreResource) {
            this.doSetProperty("keyStoreResource", keyStoreResource);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder passphrase(String passphrase) {
            this.doSetProperty("passphrase", passphrase);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder securityProvider(String securityProvider) {
            this.doSetProperty("securityProvider", securityProvider);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder ssl(boolean ssl) {
            this.doSetProperty("ssl", ssl);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder ssl(String ssl) {
            this.doSetProperty("ssl", ssl);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder sslClientCertHeaders(boolean sslClientCertHeaders) {
            this.doSetProperty("sslClientCertHeaders", sslClientCertHeaders);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder sslClientCertHeaders(String sslClientCertHeaders) {
            this.doSetProperty("sslClientCertHeaders", sslClientCertHeaders);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder sslContextParameters(SSLContextParameters sslContextParameters) {
            this.doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder sslContextParameters(String sslContextParameters) {
            this.doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder sslHandler(SslHandler sslHandler) {
            this.doSetProperty("sslHandler", sslHandler);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder sslHandler(String sslHandler) {
            this.doSetProperty("sslHandler", sslHandler);
            return this;
        }

        default public NettyHttpEndpointProducerBuilder trustStoreResource(String trustStoreResource) {
            this.doSetProperty("trustStoreResource", trustStoreResource);
            return this;
        }
    }

    public static interface AdvancedNettyHttpEndpointConsumerBuilder
    extends EndpointConsumerBuilder {
        default public NettyHttpEndpointConsumerBuilder basic() {
            return (NettyHttpEndpointConsumerBuilder)((Object)this);
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder backlog(int backlog) {
            this.doSetProperty("backlog", backlog);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder backlog(String backlog) {
            this.doSetProperty("backlog", backlog);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder bossCount(int bossCount) {
            this.doSetProperty("bossCount", bossCount);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder bossCount(String bossCount) {
            this.doSetProperty("bossCount", bossCount);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder bossGroup(EventLoopGroup bossGroup) {
            this.doSetProperty("bossGroup", bossGroup);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder bossGroup(String bossGroup) {
            this.doSetProperty("bossGroup", bossGroup);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder chunkedMaxContentLength(int chunkedMaxContentLength) {
            this.doSetProperty("chunkedMaxContentLength", chunkedMaxContentLength);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder chunkedMaxContentLength(String chunkedMaxContentLength) {
            this.doSetProperty("chunkedMaxContentLength", chunkedMaxContentLength);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder compression(boolean compression) {
            this.doSetProperty("compression", compression);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder compression(String compression) {
            this.doSetProperty("compression", compression);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder disconnectOnNoReply(boolean disconnectOnNoReply) {
            this.doSetProperty("disconnectOnNoReply", disconnectOnNoReply);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder disconnectOnNoReply(String disconnectOnNoReply) {
            this.doSetProperty("disconnectOnNoReply", disconnectOnNoReply);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder exceptionHandler(ExceptionHandler exceptionHandler) {
            this.doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            this.doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder exchangePattern(ExchangePattern exchangePattern) {
            this.doSetProperty("exchangePattern", exchangePattern);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder exchangePattern(String exchangePattern) {
            this.doSetProperty("exchangePattern", exchangePattern);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder httpMethodRestrict(String httpMethodRestrict) {
            this.doSetProperty("httpMethodRestrict", httpMethodRestrict);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder logWarnOnBadRequest(boolean logWarnOnBadRequest) {
            this.doSetProperty("logWarnOnBadRequest", logWarnOnBadRequest);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder logWarnOnBadRequest(String logWarnOnBadRequest) {
            this.doSetProperty("logWarnOnBadRequest", logWarnOnBadRequest);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder mapHeaders(boolean mapHeaders) {
            this.doSetProperty("mapHeaders", mapHeaders);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder mapHeaders(String mapHeaders) {
            this.doSetProperty("mapHeaders", mapHeaders);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder maxChunkSize(int maxChunkSize) {
            this.doSetProperty("maxChunkSize", maxChunkSize);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder maxChunkSize(String maxChunkSize) {
            this.doSetProperty("maxChunkSize", maxChunkSize);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder maxHeaderSize(int maxHeaderSize) {
            this.doSetProperty("maxHeaderSize", maxHeaderSize);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder maxHeaderSize(String maxHeaderSize) {
            this.doSetProperty("maxHeaderSize", maxHeaderSize);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder maxInitialLineLength(int maxInitialLineLength) {
            this.doSetProperty("maxInitialLineLength", maxInitialLineLength);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder maxInitialLineLength(String maxInitialLineLength) {
            this.doSetProperty("maxInitialLineLength", maxInitialLineLength);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder nettyServerBootstrapFactory(NettyServerBootstrapFactory nettyServerBootstrapFactory) {
            this.doSetProperty("nettyServerBootstrapFactory", nettyServerBootstrapFactory);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder nettyServerBootstrapFactory(String nettyServerBootstrapFactory) {
            this.doSetProperty("nettyServerBootstrapFactory", nettyServerBootstrapFactory);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder nettySharedHttpServer(NettySharedHttpServer nettySharedHttpServer) {
            this.doSetProperty("nettySharedHttpServer", nettySharedHttpServer);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder nettySharedHttpServer(String nettySharedHttpServer) {
            this.doSetProperty("nettySharedHttpServer", nettySharedHttpServer);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder noReplyLogLevel(LoggingLevel noReplyLogLevel) {
            this.doSetProperty("noReplyLogLevel", noReplyLogLevel);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder noReplyLogLevel(String noReplyLogLevel) {
            this.doSetProperty("noReplyLogLevel", noReplyLogLevel);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder serverClosedChannelExceptionCaughtLogLevel(LoggingLevel serverClosedChannelExceptionCaughtLogLevel) {
            this.doSetProperty("serverClosedChannelExceptionCaughtLogLevel", serverClosedChannelExceptionCaughtLogLevel);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder serverClosedChannelExceptionCaughtLogLevel(String serverClosedChannelExceptionCaughtLogLevel) {
            this.doSetProperty("serverClosedChannelExceptionCaughtLogLevel", serverClosedChannelExceptionCaughtLogLevel);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder serverExceptionCaughtLogLevel(LoggingLevel serverExceptionCaughtLogLevel) {
            this.doSetProperty("serverExceptionCaughtLogLevel", serverExceptionCaughtLogLevel);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder serverExceptionCaughtLogLevel(String serverExceptionCaughtLogLevel) {
            this.doSetProperty("serverExceptionCaughtLogLevel", serverExceptionCaughtLogLevel);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder serverInitializerFactory(ServerInitializerFactory serverInitializerFactory) {
            this.doSetProperty("serverInitializerFactory", serverInitializerFactory);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder serverInitializerFactory(String serverInitializerFactory) {
            this.doSetProperty("serverInitializerFactory", serverInitializerFactory);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder traceEnabled(boolean traceEnabled) {
            this.doSetProperty("traceEnabled", traceEnabled);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder traceEnabled(String traceEnabled) {
            this.doSetProperty("traceEnabled", traceEnabled);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder urlDecodeHeaders(boolean urlDecodeHeaders) {
            this.doSetProperty("urlDecodeHeaders", urlDecodeHeaders);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder urlDecodeHeaders(String urlDecodeHeaders) {
            this.doSetProperty("urlDecodeHeaders", urlDecodeHeaders);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder usingExecutorService(boolean usingExecutorService) {
            this.doSetProperty("usingExecutorService", usingExecutorService);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder usingExecutorService(String usingExecutorService) {
            this.doSetProperty("usingExecutorService", usingExecutorService);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder allowSerializedHeaders(boolean allowSerializedHeaders) {
            this.doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder allowSerializedHeaders(String allowSerializedHeaders) {
            this.doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder channelGroup(ChannelGroup channelGroup) {
            this.doSetProperty("channelGroup", channelGroup);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder channelGroup(String channelGroup) {
            this.doSetProperty("channelGroup", channelGroup);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder configuration(NettyHttpConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder configuration(String configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder disableStreamCache(boolean disableStreamCache) {
            this.doSetProperty("disableStreamCache", disableStreamCache);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder disableStreamCache(String disableStreamCache) {
            this.doSetProperty("disableStreamCache", disableStreamCache);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder headerFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
            this.doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder headerFilterStrategy(String headerFilterStrategy) {
            this.doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder nativeTransport(boolean nativeTransport) {
            this.doSetProperty("nativeTransport", nativeTransport);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder nativeTransport(String nativeTransport) {
            this.doSetProperty("nativeTransport", nativeTransport);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder nettyHttpBinding(NettyHttpBinding nettyHttpBinding) {
            this.doSetProperty("nettyHttpBinding", nettyHttpBinding);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder nettyHttpBinding(String nettyHttpBinding) {
            this.doSetProperty("nettyHttpBinding", nettyHttpBinding);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder options(String key, Object value) {
            this.doSetMultiValueProperty("options", "option." + key, value);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder options(Map values) {
            this.doSetMultiValueProperties("options", "option.", values);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder receiveBufferSize(int receiveBufferSize) {
            this.doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder receiveBufferSize(String receiveBufferSize) {
            this.doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder receiveBufferSizePredictor(int receiveBufferSizePredictor) {
            this.doSetProperty("receiveBufferSizePredictor", receiveBufferSizePredictor);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder receiveBufferSizePredictor(String receiveBufferSizePredictor) {
            this.doSetProperty("receiveBufferSizePredictor", receiveBufferSizePredictor);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder sendBufferSize(int sendBufferSize) {
            this.doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder sendBufferSize(String sendBufferSize) {
            this.doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder shutdownTimeout(int shutdownTimeout) {
            this.doSetProperty("shutdownTimeout", shutdownTimeout);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder shutdownTimeout(String shutdownTimeout) {
            this.doSetProperty("shutdownTimeout", shutdownTimeout);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder synchronous(boolean synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder synchronous(String synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder transferException(boolean transferException) {
            this.doSetProperty("transferException", transferException);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder transferException(String transferException) {
            this.doSetProperty("transferException", transferException);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder transferExchange(boolean transferExchange) {
            this.doSetProperty("transferExchange", transferExchange);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder transferExchange(String transferExchange) {
            this.doSetProperty("transferExchange", transferExchange);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder unixDomainSocketPath(String unixDomainSocketPath) {
            this.doSetProperty("unixDomainSocketPath", unixDomainSocketPath);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder workerCount(int workerCount) {
            this.doSetProperty("workerCount", workerCount);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder workerCount(String workerCount) {
            this.doSetProperty("workerCount", workerCount);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder workerGroup(EventLoopGroup workerGroup) {
            this.doSetProperty("workerGroup", workerGroup);
            return this;
        }

        default public AdvancedNettyHttpEndpointConsumerBuilder workerGroup(String workerGroup) {
            this.doSetProperty("workerGroup", workerGroup);
            return this;
        }
    }

    public static interface NettyHttpEndpointConsumerBuilder
    extends EndpointConsumerBuilder {
        default public AdvancedNettyHttpEndpointConsumerBuilder advanced() {
            return (AdvancedNettyHttpEndpointConsumerBuilder)((Object)this);
        }

        default public NettyHttpEndpointConsumerBuilder bridgeEndpoint(boolean bridgeEndpoint) {
            this.doSetProperty("bridgeEndpoint", bridgeEndpoint);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder bridgeEndpoint(String bridgeEndpoint) {
            this.doSetProperty("bridgeEndpoint", bridgeEndpoint);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder disconnect(boolean disconnect) {
            this.doSetProperty("disconnect", disconnect);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder disconnect(String disconnect) {
            this.doSetProperty("disconnect", disconnect);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder keepAlive(boolean keepAlive) {
            this.doSetProperty("keepAlive", keepAlive);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder keepAlive(String keepAlive) {
            this.doSetProperty("keepAlive", keepAlive);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder reuseAddress(boolean reuseAddress) {
            this.doSetProperty("reuseAddress", reuseAddress);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder reuseAddress(String reuseAddress) {
            this.doSetProperty("reuseAddress", reuseAddress);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder reuseChannel(boolean reuseChannel) {
            this.doSetProperty("reuseChannel", reuseChannel);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder reuseChannel(String reuseChannel) {
            this.doSetProperty("reuseChannel", reuseChannel);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder sync(boolean sync) {
            this.doSetProperty("sync", sync);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder sync(String sync) {
            this.doSetProperty("sync", sync);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder tcpNoDelay(boolean tcpNoDelay) {
            this.doSetProperty("tcpNoDelay", tcpNoDelay);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder tcpNoDelay(String tcpNoDelay) {
            this.doSetProperty("tcpNoDelay", tcpNoDelay);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder matchOnUriPrefix(boolean matchOnUriPrefix) {
            this.doSetProperty("matchOnUriPrefix", matchOnUriPrefix);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder matchOnUriPrefix(String matchOnUriPrefix) {
            this.doSetProperty("matchOnUriPrefix", matchOnUriPrefix);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder muteException(boolean muteException) {
            this.doSetProperty("muteException", muteException);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder muteException(String muteException) {
            this.doSetProperty("muteException", muteException);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder send503whenSuspended(boolean send503whenSuspended) {
            this.doSetProperty("send503whenSuspended", send503whenSuspended);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder send503whenSuspended(String send503whenSuspended) {
            this.doSetProperty("send503whenSuspended", send503whenSuspended);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder decoders(String decoders) {
            this.doSetProperty("decoders", decoders);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder encoders(String encoders) {
            this.doSetProperty("encoders", encoders);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder enabledProtocols(String enabledProtocols) {
            this.doSetProperty("enabledProtocols", enabledProtocols);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder hostnameVerification(boolean hostnameVerification) {
            this.doSetProperty("hostnameVerification", hostnameVerification);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder hostnameVerification(String hostnameVerification) {
            this.doSetProperty("hostnameVerification", hostnameVerification);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder keyStoreFormat(String keyStoreFormat) {
            this.doSetProperty("keyStoreFormat", keyStoreFormat);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder keyStoreResource(String keyStoreResource) {
            this.doSetProperty("keyStoreResource", keyStoreResource);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder needClientAuth(boolean needClientAuth) {
            this.doSetProperty("needClientAuth", needClientAuth);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder needClientAuth(String needClientAuth) {
            this.doSetProperty("needClientAuth", needClientAuth);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder passphrase(String passphrase) {
            this.doSetProperty("passphrase", passphrase);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder securityConfiguration(NettyHttpSecurityConfiguration securityConfiguration) {
            this.doSetProperty("securityConfiguration", securityConfiguration);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder securityConfiguration(String securityConfiguration) {
            this.doSetProperty("securityConfiguration", securityConfiguration);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder securityOptions(String key, Object value) {
            this.doSetMultiValueProperty("securityOptions", "securityConfiguration." + key, value);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder securityOptions(Map values) {
            this.doSetMultiValueProperties("securityOptions", "securityConfiguration.", values);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder securityProvider(String securityProvider) {
            this.doSetProperty("securityProvider", securityProvider);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder ssl(boolean ssl) {
            this.doSetProperty("ssl", ssl);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder ssl(String ssl) {
            this.doSetProperty("ssl", ssl);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder sslClientCertHeaders(boolean sslClientCertHeaders) {
            this.doSetProperty("sslClientCertHeaders", sslClientCertHeaders);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder sslClientCertHeaders(String sslClientCertHeaders) {
            this.doSetProperty("sslClientCertHeaders", sslClientCertHeaders);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder sslContextParameters(SSLContextParameters sslContextParameters) {
            this.doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder sslContextParameters(String sslContextParameters) {
            this.doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder sslHandler(SslHandler sslHandler) {
            this.doSetProperty("sslHandler", sslHandler);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder sslHandler(String sslHandler) {
            this.doSetProperty("sslHandler", sslHandler);
            return this;
        }

        default public NettyHttpEndpointConsumerBuilder trustStoreResource(String trustStoreResource) {
            this.doSetProperty("trustStoreResource", trustStoreResource);
            return this;
        }
    }
}

