/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint.dsl;

import com.azure.core.util.Context;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.BlockListType;
import com.azure.storage.common.StorageSharedKeyCredential;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.component.azure.storage.blob.BlobOperationsDefinition;
import org.apache.camel.component.azure.storage.blob.BlobType;
import org.apache.camel.component.azure.storage.blob.CredentialType;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.PollingConsumerPollStrategy;

public interface BlobEndpointBuilderFactory {
    public static BlobEndpointBuilder endpointBuilder(String componentName, String path) {
        class BlobEndpointBuilderImpl
        extends AbstractEndpointBuilder
        implements BlobEndpointBuilder,
        AdvancedBlobEndpointBuilder {
            final /* synthetic */ String val$componentName;

            public BlobEndpointBuilderImpl(String path, String string) {
                this.val$componentName = string;
                super(string, path);
            }
        }
        return new BlobEndpointBuilderImpl(path, componentName);
    }

    public static class BlobHeaderNameBuilder {
        private static final BlobHeaderNameBuilder INSTANCE = new BlobHeaderNameBuilder();

        public String azureStorageBlobOperation() {
            return "CamelAzureStorageBlobOperation";
        }

        public String azureStorageBlobHttpHeaders() {
            return "CamelAzureStorageBlobHttpHeaders";
        }

        public String azureStorageBlobETag() {
            return "CamelAzureStorageBlobETag";
        }

        public String azureStorageBlobCreationTime() {
            return "CamelAzureStorageBlobCreationTime";
        }

        public String azureStorageBlobLastModified() {
            return "CamelAzureStorageBlobLastModified";
        }

        public String azureStorageBlobContentType() {
            return "CamelAzureStorageBlobContentType";
        }

        public String azureStorageBlobContentMD5() {
            return "CamelAzureStorageBlobContentMD5";
        }

        public String azureStorageBlobContentEncoding() {
            return "CamelAzureStorageBlobContentEncoding";
        }

        public String azureStorageBlobContentDisposition() {
            return "CamelAzureStorageBlobContentDisposition";
        }

        public String azureStorageBlobContentLanguage() {
            return "CamelAzureStorageBlobContentLanguage";
        }

        public String azureStorageBlobCacheControl() {
            return "CamelAzureStorageBlobCacheControl";
        }

        public String azureStorageBlobBlobSize() {
            return "CamelAzureStorageBlobBlobSize";
        }

        public String azureStorageBlobBlobUploadSize() {
            return "CamelAzureStorageBlobBlobUploadSize";
        }

        public String azureStorageBlobSequenceNumber() {
            return "CamelAzureStorageBlobSequenceNumber";
        }

        public String azureStorageBlobBlobType() {
            return "CamelAzureStorageBlobBlobType";
        }

        public String azureStorageBlobLeaseStatus() {
            return "CamelAzureStorageBlobLeaseStatus";
        }

        public String azureStorageBlobLeaseState() {
            return "CamelAzureStorageBlobLeaseState";
        }

        public String azureStorageBlobLeaseDuration() {
            return "CamelAzureStorageBlobLeaseDuration";
        }

        public String azureStorageBlobCopyId() {
            return "CamelAzureStorageBlobCopyId";
        }

        public String azureStorageBlobCopyStatus() {
            return "CamelAzureStorageBlobCopyStatus";
        }

        public String azureStorageBlobCopySource() {
            return "CamelAzureStorageBlobCopySource";
        }

        public String azureStorageBlobCopyProgress() {
            return "CamelAzureStorageBlobCopyProgress";
        }

        public String azureStorageBlobCopyCompletionTime() {
            return "CamelAzureStorageBlobCopyCompletionTime";
        }

        public String azureStorageBlobCopyStatusDescription() {
            return "CamelAzureStorageBlobCopyStatusDescription";
        }

        public String azureStorageBlobCopyDestinationSnapshot() {
            return "CamelAzureStorageBlobCopyDestinationSnapshot";
        }

        public String azureStorageBlobIsServerEncrypted() {
            return "CamelAzureStorageBlobIsServerEncrypted";
        }

        public String azureStorageBlobIsIncrementalCopy() {
            return "CamelAzureStorageBlobIsIncrementalCopy";
        }

        public String azureStorageBlobAccessTier() {
            return "CamelAzureStorageBlobAccessTier";
        }

        public String azureStorageBlobIsAccessTierInferred() {
            return "CamelAzureStorageBlobIsAccessTierInferred";
        }

        public String azureStorageBlobArchiveStatus() {
            return "CamelAzureStorageBlobArchiveStatus";
        }

        public String azureStorageBlobaccessTierChangeTime() {
            return "CamelAzureStorageBlobaccessTierChangeTime";
        }

        public String azureStorageBlobMetadata() {
            return "CamelAzureStorageBlobMetadata";
        }

        public String azureStorageBlobCommittedBlockCount() {
            return "CamelAzureStorageBlobCommittedBlockCount";
        }

        public String azureStorageBlobAppendOffset() {
            return "CamelAzureStorageBlobAppendOffset";
        }

        public String azureStorageBlobRawHttpHeaders() {
            return "CamelAzureStorageBlobRawHttpHeaders";
        }

        public String azureStorageBlobFileName() {
            return "CamelAzureStorageBlobFileName";
        }

        public String azureStorageBlobDownloadLink() {
            return "CamelAzureStorageBlobDownloadLink";
        }

        public String azureStorageBlobListBlobOptions() {
            return "CamelAzureStorageBlobListBlobOptions";
        }

        public String azureStorageBlobListDetails() {
            return "CamelAzureStorageBlobListDetails";
        }

        public String azureStorageBlobPrefix() {
            return "CamelAzureStorageBlobPrefix";
        }

        public String azureStorageBlobRegex() {
            return "CamelAzureStorageBlobRegex";
        }

        public String azureStorageBlobMaxResultsPerPage() {
            return "CamelAzureStorageBlobMaxResultsPerPage";
        }

        public String azureStorageBlobTimeout() {
            return "CamelAzureStorageBlobTimeout";
        }

        public String azureStorageBlobPublicAccessType() {
            return "CamelAzureStorageBlobPublicAccessType";
        }

        public String azureStorageBlobRequestCondition() {
            return "CamelAzureStorageBlobRequestCondition";
        }

        public String azureStorageBlobBlobContainerName() {
            return "CamelAzureStorageBlobBlobContainerName";
        }

        public String azureStorageBlobBlobName() {
            return "CamelAzureStorageBlobBlobName";
        }

        public String azureStorageBlobFileDir() {
            return "CamelAzureStorageBlobFileDir";
        }

        public String azureStorageBlobPageBlobRange() {
            return "CamelAzureStorageBlobPageBlobRange";
        }

        public String azureStorageBlobPageBlobSize() {
            return "CamelAzureStorageBlobPageBlobSize";
        }

        public String azureStorageBlobCommitBlobBlockListLater() {
            return "CamelAzureStorageBlobCommitBlobBlockListLater";
        }

        public String azureStorageBlobBlockListType() {
            return "CamelAzureStorageBlobBlockListType";
        }

        public String azureStorageBlobCreateAppendBlob() {
            return "CamelAzureStorageBlobCreateAppendBlob";
        }

        public String azureStorageBlobCreatePageBlob() {
            return "CamelAzureStorageBlobCreatePageBlob";
        }

        public String azureStorageBlobDeleteSnapshotsOptionType() {
            return "CamelAzureStorageBlobDeleteSnapshotsOptionType";
        }

        public String azureStorageBlobListBlobContainersOptions() {
            return "CamelAzureStorageBlobListBlobContainersOptions";
        }

        public String azureStorageBlobParallelTransferOptions() {
            return "CamelAzureStorageBlobParallelTransferOptions";
        }

        public String azureStorageBlobDownloadLinkExpiration() {
            return "CamelAzureStorageBlobDownloadLinkExpiration";
        }

        public String azureStorageBlobSourceBlobAccountName() {
            return "CamelAzureStorageBlobSourceBlobAccountName";
        }

        public String azureStorageBlobSourceBlobContainerName() {
            return "CamelAzureStorageBlobSourceBlobContainerName";
        }

        public String azureStorageBlobChangeFeedStartTime() {
            return "CamelAzureStorageBlobChangeFeedStartTime";
        }

        public String azureStorageBlobChangeFeedEndTime() {
            return "CamelAzureStorageBlobChangeFeedEndTime";
        }

        public String azureStorageBlobContext() {
            return "CamelAzureStorageBlobContext";
        }
    }

    public static interface BlobBuilders {
        default public BlobHeaderNameBuilder azureStorageBlob() {
            return BlobHeaderNameBuilder.INSTANCE;
        }

        default public BlobEndpointBuilder azureStorageBlob(String path) {
            return BlobEndpointBuilderFactory.endpointBuilder("azure-storage-blob", path);
        }

        default public BlobEndpointBuilder azureStorageBlob(String componentName, String path) {
            return BlobEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    public static interface AdvancedBlobEndpointBuilder
    extends AdvancedBlobEndpointConsumerBuilder,
    AdvancedBlobEndpointProducerBuilder {
        @Override
        default public BlobEndpointBuilder basic() {
            return (BlobEndpointBuilder)((Object)this);
        }
    }

    public static interface BlobEndpointBuilder
    extends BlobEndpointConsumerBuilder,
    BlobEndpointProducerBuilder {
        @Override
        default public AdvancedBlobEndpointBuilder advanced() {
            return (AdvancedBlobEndpointBuilder)((Object)this);
        }

        @Override
        default public BlobEndpointBuilder blobName(String blobName) {
            this.doSetProperty("blobName", blobName);
            return this;
        }

        @Override
        default public BlobEndpointBuilder blobOffset(long blobOffset) {
            this.doSetProperty("blobOffset", blobOffset);
            return this;
        }

        @Override
        default public BlobEndpointBuilder blobOffset(String blobOffset) {
            this.doSetProperty("blobOffset", blobOffset);
            return this;
        }

        @Override
        default public BlobEndpointBuilder blobServiceClient(BlobServiceClient blobServiceClient) {
            this.doSetProperty("blobServiceClient", blobServiceClient);
            return this;
        }

        @Override
        default public BlobEndpointBuilder blobServiceClient(String blobServiceClient) {
            this.doSetProperty("blobServiceClient", blobServiceClient);
            return this;
        }

        @Override
        default public BlobEndpointBuilder blobType(BlobType blobType) {
            this.doSetProperty("blobType", blobType);
            return this;
        }

        @Override
        default public BlobEndpointBuilder blobType(String blobType) {
            this.doSetProperty("blobType", blobType);
            return this;
        }

        @Override
        default public BlobEndpointBuilder closeStreamAfterRead(boolean closeStreamAfterRead) {
            this.doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }

        @Override
        default public BlobEndpointBuilder closeStreamAfterRead(String closeStreamAfterRead) {
            this.doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }

        @Override
        default public BlobEndpointBuilder credentials(StorageSharedKeyCredential credentials) {
            this.doSetProperty("credentials", credentials);
            return this;
        }

        @Override
        default public BlobEndpointBuilder credentials(String credentials) {
            this.doSetProperty("credentials", credentials);
            return this;
        }

        @Override
        default public BlobEndpointBuilder credentialType(CredentialType credentialType) {
            this.doSetProperty("credentialType", credentialType);
            return this;
        }

        @Override
        default public BlobEndpointBuilder credentialType(String credentialType) {
            this.doSetProperty("credentialType", credentialType);
            return this;
        }

        @Override
        default public BlobEndpointBuilder dataCount(Long dataCount) {
            this.doSetProperty("dataCount", dataCount);
            return this;
        }

        @Override
        default public BlobEndpointBuilder dataCount(String dataCount) {
            this.doSetProperty("dataCount", dataCount);
            return this;
        }

        @Override
        default public BlobEndpointBuilder fileDir(String fileDir) {
            this.doSetProperty("fileDir", fileDir);
            return this;
        }

        @Override
        default public BlobEndpointBuilder maxResultsPerPage(Integer maxResultsPerPage) {
            this.doSetProperty("maxResultsPerPage", maxResultsPerPage);
            return this;
        }

        @Override
        default public BlobEndpointBuilder maxResultsPerPage(String maxResultsPerPage) {
            this.doSetProperty("maxResultsPerPage", maxResultsPerPage);
            return this;
        }

        @Override
        default public BlobEndpointBuilder maxRetryRequests(int maxRetryRequests) {
            this.doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }

        @Override
        default public BlobEndpointBuilder maxRetryRequests(String maxRetryRequests) {
            this.doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }

        @Override
        default public BlobEndpointBuilder prefix(String prefix) {
            this.doSetProperty("prefix", prefix);
            return this;
        }

        @Override
        default public BlobEndpointBuilder regex(String regex) {
            this.doSetProperty("regex", regex);
            return this;
        }

        @Override
        default public BlobEndpointBuilder sasToken(String sasToken) {
            this.doSetProperty("sasToken", sasToken);
            return this;
        }

        @Override
        default public BlobEndpointBuilder serviceClient(BlobServiceClient serviceClient) {
            this.doSetProperty("serviceClient", serviceClient);
            return this;
        }

        @Override
        default public BlobEndpointBuilder serviceClient(String serviceClient) {
            this.doSetProperty("serviceClient", serviceClient);
            return this;
        }

        @Override
        default public BlobEndpointBuilder timeout(Duration timeout) {
            this.doSetProperty("timeout", timeout);
            return this;
        }

        @Override
        default public BlobEndpointBuilder timeout(String timeout) {
            this.doSetProperty("timeout", timeout);
            return this;
        }

        @Override
        default public BlobEndpointBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        @Override
        default public BlobEndpointBuilder sourceBlobAccessKey(String sourceBlobAccessKey) {
            this.doSetProperty("sourceBlobAccessKey", sourceBlobAccessKey);
            return this;
        }
    }

    public static interface AdvancedBlobEndpointProducerBuilder
    extends EndpointProducerBuilder {
        default public BlobEndpointProducerBuilder basic() {
            return (BlobEndpointProducerBuilder)((Object)this);
        }

        default public AdvancedBlobEndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedBlobEndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public static interface BlobEndpointProducerBuilder
    extends EndpointProducerBuilder {
        default public AdvancedBlobEndpointProducerBuilder advanced() {
            return (AdvancedBlobEndpointProducerBuilder)((Object)this);
        }

        default public BlobEndpointProducerBuilder blobName(String blobName) {
            this.doSetProperty("blobName", blobName);
            return this;
        }

        default public BlobEndpointProducerBuilder blobOffset(long blobOffset) {
            this.doSetProperty("blobOffset", blobOffset);
            return this;
        }

        default public BlobEndpointProducerBuilder blobOffset(String blobOffset) {
            this.doSetProperty("blobOffset", blobOffset);
            return this;
        }

        default public BlobEndpointProducerBuilder blobServiceClient(BlobServiceClient blobServiceClient) {
            this.doSetProperty("blobServiceClient", blobServiceClient);
            return this;
        }

        default public BlobEndpointProducerBuilder blobServiceClient(String blobServiceClient) {
            this.doSetProperty("blobServiceClient", blobServiceClient);
            return this;
        }

        default public BlobEndpointProducerBuilder blobType(BlobType blobType) {
            this.doSetProperty("blobType", blobType);
            return this;
        }

        default public BlobEndpointProducerBuilder blobType(String blobType) {
            this.doSetProperty("blobType", blobType);
            return this;
        }

        default public BlobEndpointProducerBuilder closeStreamAfterRead(boolean closeStreamAfterRead) {
            this.doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }

        default public BlobEndpointProducerBuilder closeStreamAfterRead(String closeStreamAfterRead) {
            this.doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }

        default public BlobEndpointProducerBuilder credentials(StorageSharedKeyCredential credentials) {
            this.doSetProperty("credentials", credentials);
            return this;
        }

        default public BlobEndpointProducerBuilder credentials(String credentials) {
            this.doSetProperty("credentials", credentials);
            return this;
        }

        default public BlobEndpointProducerBuilder credentialType(CredentialType credentialType) {
            this.doSetProperty("credentialType", credentialType);
            return this;
        }

        default public BlobEndpointProducerBuilder credentialType(String credentialType) {
            this.doSetProperty("credentialType", credentialType);
            return this;
        }

        default public BlobEndpointProducerBuilder dataCount(Long dataCount) {
            this.doSetProperty("dataCount", dataCount);
            return this;
        }

        default public BlobEndpointProducerBuilder dataCount(String dataCount) {
            this.doSetProperty("dataCount", dataCount);
            return this;
        }

        default public BlobEndpointProducerBuilder fileDir(String fileDir) {
            this.doSetProperty("fileDir", fileDir);
            return this;
        }

        default public BlobEndpointProducerBuilder maxResultsPerPage(Integer maxResultsPerPage) {
            this.doSetProperty("maxResultsPerPage", maxResultsPerPage);
            return this;
        }

        default public BlobEndpointProducerBuilder maxResultsPerPage(String maxResultsPerPage) {
            this.doSetProperty("maxResultsPerPage", maxResultsPerPage);
            return this;
        }

        default public BlobEndpointProducerBuilder maxRetryRequests(int maxRetryRequests) {
            this.doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }

        default public BlobEndpointProducerBuilder maxRetryRequests(String maxRetryRequests) {
            this.doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }

        default public BlobEndpointProducerBuilder prefix(String prefix) {
            this.doSetProperty("prefix", prefix);
            return this;
        }

        default public BlobEndpointProducerBuilder regex(String regex) {
            this.doSetProperty("regex", regex);
            return this;
        }

        default public BlobEndpointProducerBuilder sasToken(String sasToken) {
            this.doSetProperty("sasToken", sasToken);
            return this;
        }

        default public BlobEndpointProducerBuilder serviceClient(BlobServiceClient serviceClient) {
            this.doSetProperty("serviceClient", serviceClient);
            return this;
        }

        default public BlobEndpointProducerBuilder serviceClient(String serviceClient) {
            this.doSetProperty("serviceClient", serviceClient);
            return this;
        }

        default public BlobEndpointProducerBuilder timeout(Duration timeout) {
            this.doSetProperty("timeout", timeout);
            return this;
        }

        default public BlobEndpointProducerBuilder timeout(String timeout) {
            this.doSetProperty("timeout", timeout);
            return this;
        }

        default public BlobEndpointProducerBuilder blobSequenceNumber(Long blobSequenceNumber) {
            this.doSetProperty("blobSequenceNumber", blobSequenceNumber);
            return this;
        }

        default public BlobEndpointProducerBuilder blobSequenceNumber(String blobSequenceNumber) {
            this.doSetProperty("blobSequenceNumber", blobSequenceNumber);
            return this;
        }

        default public BlobEndpointProducerBuilder blockListType(BlockListType blockListType) {
            this.doSetProperty("blockListType", blockListType);
            return this;
        }

        default public BlobEndpointProducerBuilder blockListType(String blockListType) {
            this.doSetProperty("blockListType", blockListType);
            return this;
        }

        default public BlobEndpointProducerBuilder changeFeedContext(Context changeFeedContext) {
            this.doSetProperty("changeFeedContext", changeFeedContext);
            return this;
        }

        default public BlobEndpointProducerBuilder changeFeedContext(String changeFeedContext) {
            this.doSetProperty("changeFeedContext", changeFeedContext);
            return this;
        }

        default public BlobEndpointProducerBuilder changeFeedEndTime(OffsetDateTime changeFeedEndTime) {
            this.doSetProperty("changeFeedEndTime", changeFeedEndTime);
            return this;
        }

        default public BlobEndpointProducerBuilder changeFeedEndTime(String changeFeedEndTime) {
            this.doSetProperty("changeFeedEndTime", changeFeedEndTime);
            return this;
        }

        default public BlobEndpointProducerBuilder changeFeedStartTime(OffsetDateTime changeFeedStartTime) {
            this.doSetProperty("changeFeedStartTime", changeFeedStartTime);
            return this;
        }

        default public BlobEndpointProducerBuilder changeFeedStartTime(String changeFeedStartTime) {
            this.doSetProperty("changeFeedStartTime", changeFeedStartTime);
            return this;
        }

        default public BlobEndpointProducerBuilder closeStreamAfterWrite(boolean closeStreamAfterWrite) {
            this.doSetProperty("closeStreamAfterWrite", closeStreamAfterWrite);
            return this;
        }

        default public BlobEndpointProducerBuilder closeStreamAfterWrite(String closeStreamAfterWrite) {
            this.doSetProperty("closeStreamAfterWrite", closeStreamAfterWrite);
            return this;
        }

        default public BlobEndpointProducerBuilder commitBlockListLater(boolean commitBlockListLater) {
            this.doSetProperty("commitBlockListLater", commitBlockListLater);
            return this;
        }

        default public BlobEndpointProducerBuilder commitBlockListLater(String commitBlockListLater) {
            this.doSetProperty("commitBlockListLater", commitBlockListLater);
            return this;
        }

        default public BlobEndpointProducerBuilder createAppendBlob(boolean createAppendBlob) {
            this.doSetProperty("createAppendBlob", createAppendBlob);
            return this;
        }

        default public BlobEndpointProducerBuilder createAppendBlob(String createAppendBlob) {
            this.doSetProperty("createAppendBlob", createAppendBlob);
            return this;
        }

        default public BlobEndpointProducerBuilder createPageBlob(boolean createPageBlob) {
            this.doSetProperty("createPageBlob", createPageBlob);
            return this;
        }

        default public BlobEndpointProducerBuilder createPageBlob(String createPageBlob) {
            this.doSetProperty("createPageBlob", createPageBlob);
            return this;
        }

        default public BlobEndpointProducerBuilder downloadLinkExpiration(Long downloadLinkExpiration) {
            this.doSetProperty("downloadLinkExpiration", downloadLinkExpiration);
            return this;
        }

        default public BlobEndpointProducerBuilder downloadLinkExpiration(String downloadLinkExpiration) {
            this.doSetProperty("downloadLinkExpiration", downloadLinkExpiration);
            return this;
        }

        default public BlobEndpointProducerBuilder operation(BlobOperationsDefinition operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public BlobEndpointProducerBuilder operation(String operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public BlobEndpointProducerBuilder pageBlobSize(Long pageBlobSize) {
            this.doSetProperty("pageBlobSize", pageBlobSize);
            return this;
        }

        default public BlobEndpointProducerBuilder pageBlobSize(String pageBlobSize) {
            this.doSetProperty("pageBlobSize", pageBlobSize);
            return this;
        }

        default public BlobEndpointProducerBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public BlobEndpointProducerBuilder sourceBlobAccessKey(String sourceBlobAccessKey) {
            this.doSetProperty("sourceBlobAccessKey", sourceBlobAccessKey);
            return this;
        }
    }

    public static interface AdvancedBlobEndpointConsumerBuilder
    extends EndpointConsumerBuilder {
        default public BlobEndpointConsumerBuilder basic() {
            return (BlobEndpointConsumerBuilder)((Object)this);
        }

        default public AdvancedBlobEndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AdvancedBlobEndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AdvancedBlobEndpointConsumerBuilder exceptionHandler(ExceptionHandler exceptionHandler) {
            this.doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }

        default public AdvancedBlobEndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            this.doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }

        default public AdvancedBlobEndpointConsumerBuilder exchangePattern(ExchangePattern exchangePattern) {
            this.doSetProperty("exchangePattern", exchangePattern);
            return this;
        }

        default public AdvancedBlobEndpointConsumerBuilder exchangePattern(String exchangePattern) {
            this.doSetProperty("exchangePattern", exchangePattern);
            return this;
        }

        default public AdvancedBlobEndpointConsumerBuilder pollStrategy(PollingConsumerPollStrategy pollStrategy) {
            this.doSetProperty("pollStrategy", pollStrategy);
            return this;
        }

        default public AdvancedBlobEndpointConsumerBuilder pollStrategy(String pollStrategy) {
            this.doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
    }

    public static interface BlobEndpointConsumerBuilder
    extends EndpointConsumerBuilder {
        default public AdvancedBlobEndpointConsumerBuilder advanced() {
            return (AdvancedBlobEndpointConsumerBuilder)((Object)this);
        }

        default public BlobEndpointConsumerBuilder blobName(String blobName) {
            this.doSetProperty("blobName", blobName);
            return this;
        }

        default public BlobEndpointConsumerBuilder blobOffset(long blobOffset) {
            this.doSetProperty("blobOffset", blobOffset);
            return this;
        }

        default public BlobEndpointConsumerBuilder blobOffset(String blobOffset) {
            this.doSetProperty("blobOffset", blobOffset);
            return this;
        }

        default public BlobEndpointConsumerBuilder blobServiceClient(BlobServiceClient blobServiceClient) {
            this.doSetProperty("blobServiceClient", blobServiceClient);
            return this;
        }

        default public BlobEndpointConsumerBuilder blobServiceClient(String blobServiceClient) {
            this.doSetProperty("blobServiceClient", blobServiceClient);
            return this;
        }

        default public BlobEndpointConsumerBuilder blobType(BlobType blobType) {
            this.doSetProperty("blobType", blobType);
            return this;
        }

        default public BlobEndpointConsumerBuilder blobType(String blobType) {
            this.doSetProperty("blobType", blobType);
            return this;
        }

        default public BlobEndpointConsumerBuilder closeStreamAfterRead(boolean closeStreamAfterRead) {
            this.doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }

        default public BlobEndpointConsumerBuilder closeStreamAfterRead(String closeStreamAfterRead) {
            this.doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }

        default public BlobEndpointConsumerBuilder credentials(StorageSharedKeyCredential credentials) {
            this.doSetProperty("credentials", credentials);
            return this;
        }

        default public BlobEndpointConsumerBuilder credentials(String credentials) {
            this.doSetProperty("credentials", credentials);
            return this;
        }

        default public BlobEndpointConsumerBuilder credentialType(CredentialType credentialType) {
            this.doSetProperty("credentialType", credentialType);
            return this;
        }

        default public BlobEndpointConsumerBuilder credentialType(String credentialType) {
            this.doSetProperty("credentialType", credentialType);
            return this;
        }

        default public BlobEndpointConsumerBuilder dataCount(Long dataCount) {
            this.doSetProperty("dataCount", dataCount);
            return this;
        }

        default public BlobEndpointConsumerBuilder dataCount(String dataCount) {
            this.doSetProperty("dataCount", dataCount);
            return this;
        }

        default public BlobEndpointConsumerBuilder fileDir(String fileDir) {
            this.doSetProperty("fileDir", fileDir);
            return this;
        }

        default public BlobEndpointConsumerBuilder maxResultsPerPage(Integer maxResultsPerPage) {
            this.doSetProperty("maxResultsPerPage", maxResultsPerPage);
            return this;
        }

        default public BlobEndpointConsumerBuilder maxResultsPerPage(String maxResultsPerPage) {
            this.doSetProperty("maxResultsPerPage", maxResultsPerPage);
            return this;
        }

        default public BlobEndpointConsumerBuilder maxRetryRequests(int maxRetryRequests) {
            this.doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }

        default public BlobEndpointConsumerBuilder maxRetryRequests(String maxRetryRequests) {
            this.doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }

        default public BlobEndpointConsumerBuilder prefix(String prefix) {
            this.doSetProperty("prefix", prefix);
            return this;
        }

        default public BlobEndpointConsumerBuilder regex(String regex) {
            this.doSetProperty("regex", regex);
            return this;
        }

        default public BlobEndpointConsumerBuilder sasToken(String sasToken) {
            this.doSetProperty("sasToken", sasToken);
            return this;
        }

        default public BlobEndpointConsumerBuilder serviceClient(BlobServiceClient serviceClient) {
            this.doSetProperty("serviceClient", serviceClient);
            return this;
        }

        default public BlobEndpointConsumerBuilder serviceClient(String serviceClient) {
            this.doSetProperty("serviceClient", serviceClient);
            return this;
        }

        default public BlobEndpointConsumerBuilder timeout(Duration timeout) {
            this.doSetProperty("timeout", timeout);
            return this;
        }

        default public BlobEndpointConsumerBuilder timeout(String timeout) {
            this.doSetProperty("timeout", timeout);
            return this;
        }

        default public BlobEndpointConsumerBuilder sendEmptyMessageWhenIdle(boolean sendEmptyMessageWhenIdle) {
            this.doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }

        default public BlobEndpointConsumerBuilder sendEmptyMessageWhenIdle(String sendEmptyMessageWhenIdle) {
            this.doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }

        default public BlobEndpointConsumerBuilder backoffErrorThreshold(int backoffErrorThreshold) {
            this.doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }

        default public BlobEndpointConsumerBuilder backoffErrorThreshold(String backoffErrorThreshold) {
            this.doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }

        default public BlobEndpointConsumerBuilder backoffIdleThreshold(int backoffIdleThreshold) {
            this.doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }

        default public BlobEndpointConsumerBuilder backoffIdleThreshold(String backoffIdleThreshold) {
            this.doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }

        default public BlobEndpointConsumerBuilder backoffMultiplier(int backoffMultiplier) {
            this.doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }

        default public BlobEndpointConsumerBuilder backoffMultiplier(String backoffMultiplier) {
            this.doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }

        default public BlobEndpointConsumerBuilder delay(long delay) {
            this.doSetProperty("delay", delay);
            return this;
        }

        default public BlobEndpointConsumerBuilder delay(String delay) {
            this.doSetProperty("delay", delay);
            return this;
        }

        default public BlobEndpointConsumerBuilder greedy(boolean greedy) {
            this.doSetProperty("greedy", greedy);
            return this;
        }

        default public BlobEndpointConsumerBuilder greedy(String greedy) {
            this.doSetProperty("greedy", greedy);
            return this;
        }

        default public BlobEndpointConsumerBuilder initialDelay(long initialDelay) {
            this.doSetProperty("initialDelay", initialDelay);
            return this;
        }

        default public BlobEndpointConsumerBuilder initialDelay(String initialDelay) {
            this.doSetProperty("initialDelay", initialDelay);
            return this;
        }

        default public BlobEndpointConsumerBuilder repeatCount(long repeatCount) {
            this.doSetProperty("repeatCount", repeatCount);
            return this;
        }

        default public BlobEndpointConsumerBuilder repeatCount(String repeatCount) {
            this.doSetProperty("repeatCount", repeatCount);
            return this;
        }

        default public BlobEndpointConsumerBuilder runLoggingLevel(LoggingLevel runLoggingLevel) {
            this.doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }

        default public BlobEndpointConsumerBuilder runLoggingLevel(String runLoggingLevel) {
            this.doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }

        default public BlobEndpointConsumerBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            this.doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }

        default public BlobEndpointConsumerBuilder scheduledExecutorService(String scheduledExecutorService) {
            this.doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }

        default public BlobEndpointConsumerBuilder scheduler(Object scheduler) {
            this.doSetProperty("scheduler", scheduler);
            return this;
        }

        default public BlobEndpointConsumerBuilder scheduler(String scheduler) {
            this.doSetProperty("scheduler", scheduler);
            return this;
        }

        default public BlobEndpointConsumerBuilder schedulerProperties(String key, Object value) {
            this.doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }

        default public BlobEndpointConsumerBuilder schedulerProperties(Map values) {
            this.doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }

        default public BlobEndpointConsumerBuilder startScheduler(boolean startScheduler) {
            this.doSetProperty("startScheduler", startScheduler);
            return this;
        }

        default public BlobEndpointConsumerBuilder startScheduler(String startScheduler) {
            this.doSetProperty("startScheduler", startScheduler);
            return this;
        }

        default public BlobEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            this.doSetProperty("timeUnit", (Object)timeUnit);
            return this;
        }

        default public BlobEndpointConsumerBuilder timeUnit(String timeUnit) {
            this.doSetProperty("timeUnit", timeUnit);
            return this;
        }

        default public BlobEndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            this.doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }

        default public BlobEndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            this.doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }

        default public BlobEndpointConsumerBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public BlobEndpointConsumerBuilder sourceBlobAccessKey(String sourceBlobAccessKey) {
            this.doSetProperty("sourceBlobAccessKey", sourceBlobAccessKey);
            return this;
        }
    }
}

