/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint.dsl;

import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.component.redis.Command;
import org.apache.camel.spi.ExceptionHandler;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.serializer.RedisSerializer;

public interface RedisEndpointBuilderFactory {
    public static RedisEndpointBuilder endpointBuilder(String componentName, String path) {
        class RedisEndpointBuilderImpl
        extends AbstractEndpointBuilder
        implements RedisEndpointBuilder,
        AdvancedRedisEndpointBuilder {
            final /* synthetic */ String val$componentName;

            public RedisEndpointBuilderImpl(String path, String string) {
                this.val$componentName = string;
                super(string, path);
            }
        }
        return new RedisEndpointBuilderImpl(path, componentName);
    }

    public static class RedisHeaderNameBuilder {
        private static final RedisHeaderNameBuilder INSTANCE = new RedisHeaderNameBuilder();

        public String redisCommand() {
            return "Redis.Command";
        }

        public String redisKey() {
            return "Redis.Key";
        }

        public String redisKeys() {
            return "Redis.Keys";
        }

        public String redisField() {
            return "Redis.Field";
        }

        public String redisFields() {
            return "Redis.Fields";
        }

        public String redisValue() {
            return "Redis.Value";
        }

        public String redisValues() {
            return "Redis.Values";
        }

        public String redisStart() {
            return "Redis.Start";
        }

        public String redisEnd() {
            return "Redis.End";
        }

        public String redisTimeout() {
            return "Redis.Timeout";
        }

        public String redisOffset() {
            return "Redis.Offset";
        }

        public String redisDestination() {
            return "Redis.Destination";
        }

        public String redisChannel() {
            return "Redis.Channel";
        }

        public String redisMessage() {
            return "Redis.Message";
        }

        public String redisIndex() {
            return "Redis.Index";
        }

        public String redisPosition() {
            return "Redis.Position";
        }

        public String redisPivot() {
            return "Redis.Pivot";
        }

        public String redisCount() {
            return "Redis.Count";
        }

        public String redisTimestamp() {
            return "Redis.Timestamp";
        }

        public String redisPattern() {
            return "Redis.Pattern";
        }

        public String redisDb() {
            return "Redis.Db";
        }

        public String redisScore() {
            return "Redis.Score";
        }

        public String redisMin() {
            return "Redis.Min";
        }

        public String redisMax() {
            return "Redis.Max";
        }

        public String redisIncrement() {
            return "Redis.Increment";
        }

        public String redisWithscore() {
            return "Redis.WithScore";
        }

        public String redisLatitude() {
            return "Redis.Latitude";
        }

        public String redisLongitude() {
            return "Redis.Longitude";
        }

        public String redisRadius() {
            return "Redis.Radius";
        }
    }

    public static interface RedisBuilders {
        default public RedisHeaderNameBuilder springRedis() {
            return RedisHeaderNameBuilder.INSTANCE;
        }

        default public RedisEndpointBuilder springRedis(String path) {
            return RedisEndpointBuilderFactory.endpointBuilder("spring-redis", path);
        }

        default public RedisEndpointBuilder springRedis(String componentName, String path) {
            return RedisEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    public static interface AdvancedRedisEndpointBuilder
    extends AdvancedRedisEndpointConsumerBuilder,
    AdvancedRedisEndpointProducerBuilder {
        @Override
        default public RedisEndpointBuilder basic() {
            return (RedisEndpointBuilder)((Object)this);
        }
    }

    public static interface RedisEndpointBuilder
    extends RedisEndpointConsumerBuilder,
    RedisEndpointProducerBuilder {
        @Override
        default public AdvancedRedisEndpointBuilder advanced() {
            return (AdvancedRedisEndpointBuilder)((Object)this);
        }

        @Override
        default public RedisEndpointBuilder channels(String channels) {
            this.doSetProperty("channels", channels);
            return this;
        }

        @Override
        default public RedisEndpointBuilder command(Command command) {
            this.doSetProperty("command", command);
            return this;
        }

        @Override
        default public RedisEndpointBuilder command(String command) {
            this.doSetProperty("command", command);
            return this;
        }

        @Override
        default public RedisEndpointBuilder connectionFactory(RedisConnectionFactory connectionFactory) {
            this.doSetProperty("connectionFactory", connectionFactory);
            return this;
        }

        @Override
        default public RedisEndpointBuilder connectionFactory(String connectionFactory) {
            this.doSetProperty("connectionFactory", connectionFactory);
            return this;
        }

        @Override
        default public RedisEndpointBuilder redisTemplate(RedisTemplate<Object, Object> redisTemplate) {
            this.doSetProperty("redisTemplate", redisTemplate);
            return this;
        }

        @Override
        default public RedisEndpointBuilder redisTemplate(String redisTemplate) {
            this.doSetProperty("redisTemplate", redisTemplate);
            return this;
        }

        @Override
        default public RedisEndpointBuilder serializer(RedisSerializer<Object> serializer) {
            this.doSetProperty("serializer", serializer);
            return this;
        }

        @Override
        default public RedisEndpointBuilder serializer(String serializer) {
            this.doSetProperty("serializer", serializer);
            return this;
        }
    }

    public static interface AdvancedRedisEndpointProducerBuilder
    extends EndpointProducerBuilder {
        default public RedisEndpointProducerBuilder basic() {
            return (RedisEndpointProducerBuilder)((Object)this);
        }

        default public AdvancedRedisEndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedRedisEndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public static interface RedisEndpointProducerBuilder
    extends EndpointProducerBuilder {
        default public AdvancedRedisEndpointProducerBuilder advanced() {
            return (AdvancedRedisEndpointProducerBuilder)((Object)this);
        }

        default public RedisEndpointProducerBuilder channels(String channels) {
            this.doSetProperty("channels", channels);
            return this;
        }

        default public RedisEndpointProducerBuilder command(Command command) {
            this.doSetProperty("command", command);
            return this;
        }

        default public RedisEndpointProducerBuilder command(String command) {
            this.doSetProperty("command", command);
            return this;
        }

        default public RedisEndpointProducerBuilder connectionFactory(RedisConnectionFactory connectionFactory) {
            this.doSetProperty("connectionFactory", connectionFactory);
            return this;
        }

        default public RedisEndpointProducerBuilder connectionFactory(String connectionFactory) {
            this.doSetProperty("connectionFactory", connectionFactory);
            return this;
        }

        default public RedisEndpointProducerBuilder redisTemplate(RedisTemplate<Object, Object> redisTemplate) {
            this.doSetProperty("redisTemplate", redisTemplate);
            return this;
        }

        default public RedisEndpointProducerBuilder redisTemplate(String redisTemplate) {
            this.doSetProperty("redisTemplate", redisTemplate);
            return this;
        }

        default public RedisEndpointProducerBuilder serializer(RedisSerializer<Object> serializer) {
            this.doSetProperty("serializer", serializer);
            return this;
        }

        default public RedisEndpointProducerBuilder serializer(String serializer) {
            this.doSetProperty("serializer", serializer);
            return this;
        }
    }

    public static interface AdvancedRedisEndpointConsumerBuilder
    extends EndpointConsumerBuilder {
        default public RedisEndpointConsumerBuilder basic() {
            return (RedisEndpointConsumerBuilder)((Object)this);
        }

        default public AdvancedRedisEndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AdvancedRedisEndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AdvancedRedisEndpointConsumerBuilder exceptionHandler(ExceptionHandler exceptionHandler) {
            this.doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }

        default public AdvancedRedisEndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            this.doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }

        default public AdvancedRedisEndpointConsumerBuilder exchangePattern(ExchangePattern exchangePattern) {
            this.doSetProperty("exchangePattern", exchangePattern);
            return this;
        }

        default public AdvancedRedisEndpointConsumerBuilder exchangePattern(String exchangePattern) {
            this.doSetProperty("exchangePattern", exchangePattern);
            return this;
        }

        default public AdvancedRedisEndpointConsumerBuilder listenerContainer(RedisMessageListenerContainer listenerContainer) {
            this.doSetProperty("listenerContainer", listenerContainer);
            return this;
        }

        default public AdvancedRedisEndpointConsumerBuilder listenerContainer(String listenerContainer) {
            this.doSetProperty("listenerContainer", listenerContainer);
            return this;
        }
    }

    public static interface RedisEndpointConsumerBuilder
    extends EndpointConsumerBuilder {
        default public AdvancedRedisEndpointConsumerBuilder advanced() {
            return (AdvancedRedisEndpointConsumerBuilder)((Object)this);
        }

        default public RedisEndpointConsumerBuilder channels(String channels) {
            this.doSetProperty("channels", channels);
            return this;
        }

        default public RedisEndpointConsumerBuilder command(Command command) {
            this.doSetProperty("command", command);
            return this;
        }

        default public RedisEndpointConsumerBuilder command(String command) {
            this.doSetProperty("command", command);
            return this;
        }

        default public RedisEndpointConsumerBuilder connectionFactory(RedisConnectionFactory connectionFactory) {
            this.doSetProperty("connectionFactory", connectionFactory);
            return this;
        }

        default public RedisEndpointConsumerBuilder connectionFactory(String connectionFactory) {
            this.doSetProperty("connectionFactory", connectionFactory);
            return this;
        }

        default public RedisEndpointConsumerBuilder redisTemplate(RedisTemplate<Object, Object> redisTemplate) {
            this.doSetProperty("redisTemplate", redisTemplate);
            return this;
        }

        default public RedisEndpointConsumerBuilder redisTemplate(String redisTemplate) {
            this.doSetProperty("redisTemplate", redisTemplate);
            return this;
        }

        default public RedisEndpointConsumerBuilder serializer(RedisSerializer<Object> serializer) {
            this.doSetProperty("serializer", serializer);
            return this;
        }

        default public RedisEndpointConsumerBuilder serializer(String serializer) {
            this.doSetProperty("serializer", serializer);
            return this;
        }
    }
}

