/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint.dsl;

import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.component.aws2.ecs.ECS2Operations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.ecs.EcsClient;

public interface ECS2EndpointBuilderFactory {
    public static ECS2EndpointBuilder endpointBuilder(String componentName, String path) {
        class ECS2EndpointBuilderImpl
        extends AbstractEndpointBuilder
        implements ECS2EndpointBuilder,
        AdvancedECS2EndpointBuilder {
            final /* synthetic */ String val$componentName;

            public ECS2EndpointBuilderImpl(String path, String string) {
                this.val$componentName = string;
                super(string, path);
            }
        }
        return new ECS2EndpointBuilderImpl(path, componentName);
    }

    public static class ECS2HeaderNameBuilder {
        private static final ECS2HeaderNameBuilder INSTANCE = new ECS2HeaderNameBuilder();

        public String awsECSOperation() {
            return "CamelAwsECSOperation";
        }

        public String awsECSMaxResults() {
            return "CamelAwsECSMaxResults";
        }

        public String awsECSClusterName() {
            return "CamelAwsECSClusterName";
        }
    }

    public static interface ECS2Builders {
        default public ECS2HeaderNameBuilder aws2Ecs() {
            return ECS2HeaderNameBuilder.INSTANCE;
        }

        default public ECS2EndpointBuilder aws2Ecs(String path) {
            return ECS2EndpointBuilderFactory.endpointBuilder("aws2-ecs", path);
        }

        default public ECS2EndpointBuilder aws2Ecs(String componentName, String path) {
            return ECS2EndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    public static interface AdvancedECS2EndpointBuilder
    extends EndpointProducerBuilder {
        default public ECS2EndpointBuilder basic() {
            return (ECS2EndpointBuilder)((Object)this);
        }

        default public AdvancedECS2EndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedECS2EndpointBuilder lazyStartProducer(String lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public static interface ECS2EndpointBuilder
    extends EndpointProducerBuilder {
        default public AdvancedECS2EndpointBuilder advanced() {
            return (AdvancedECS2EndpointBuilder)((Object)this);
        }

        default public ECS2EndpointBuilder ecsClient(EcsClient ecsClient) {
            this.doSetProperty("ecsClient", ecsClient);
            return this;
        }

        default public ECS2EndpointBuilder ecsClient(String ecsClient) {
            this.doSetProperty("ecsClient", ecsClient);
            return this;
        }

        default public ECS2EndpointBuilder operation(ECS2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public ECS2EndpointBuilder operation(String operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public ECS2EndpointBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public ECS2EndpointBuilder overrideEndpoint(String overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public ECS2EndpointBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public ECS2EndpointBuilder pojoRequest(String pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public ECS2EndpointBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public ECS2EndpointBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public ECS2EndpointBuilder proxyPort(String proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public ECS2EndpointBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public ECS2EndpointBuilder proxyProtocol(String proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public ECS2EndpointBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public ECS2EndpointBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public ECS2EndpointBuilder trustAllCertificates(String trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public ECS2EndpointBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public ECS2EndpointBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public ECS2EndpointBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public ECS2EndpointBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public ECS2EndpointBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

