/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.support;

import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.StartupStep;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.RouteBuilderLifecycleStrategy;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.support.RoutesBuilderLoaderSupport;

public abstract class RouteBuilderLoaderSupport
extends RoutesBuilderLoaderSupport {
    private final String extension;
    private StartupStepRecorder recorder;

    protected RouteBuilderLoaderSupport(String extension) {
        this.extension = extension;
    }

    @ManagedAttribute(description="Supported file extension")
    public String getSupportedExtension() {
        return this.extension;
    }

    protected void doBuild() throws Exception {
        super.doBuild();
        if (this.getCamelContext() != null) {
            this.recorder = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getStartupStepRecorder();
        }
    }

    public RoutesBuilder loadRoutesBuilder(Resource resource) throws Exception {
        RouteBuilder builder = this.doLoadRouteBuilder(resource);
        if (this.recorder != null) {
            final StartupStep step = this.recorder.beginStep(((Object)((Object)this)).getClass(), resource.getLocation(), "Loading route from: " + resource.getLocation());
            builder.addLifecycleInterceptor(new RouteBuilderLifecycleStrategy(){

                public void afterConfigure(RouteBuilder builder) {
                    step.endStep();
                }
            });
        }
        return builder;
    }

    protected abstract RouteBuilder doLoadRouteBuilder(Resource var1) throws Exception;
}

