/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.modeline;

import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.dsl.modeline.ModelineParser;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.DependencyStrategy;
import org.apache.camel.spi.Resource;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.StringQuoteHelper;

public class JBangModelineParser
implements ModelineParser {
    public static final String JBANG_DEPS_START = "//DEPS";

    @Override
    public List<CamelContextCustomizer> parse(Resource resource) throws Exception {
        ArrayList<CamelContextCustomizer> answer = new ArrayList<CamelContextCustomizer>();
        if (resource.exists()) {
            try (LineNumberReader reader = new LineNumberReader(resource.getReader());){
                String line = reader.readLine();
                while (line != null) {
                    List<CamelContextCustomizer> list = this.parse(line);
                    answer.addAll(list);
                    line = reader.readLine();
                }
            }
        }
        return answer;
    }

    @Override
    public boolean isModeline(String line) {
        if (line == null) {
            return false;
        }
        line = JBangModelineParser.removeLeadingComments(line);
        return line.startsWith(JBANG_DEPS_START);
    }

    protected List<CamelContextCustomizer> parse(String line) {
        if (!this.isModeline(line)) {
            return Collections.emptyList();
        }
        line = JBangModelineParser.removeLeadingComments(line);
        ArrayList<CamelContextCustomizer> answer = new ArrayList<CamelContextCustomizer>();
        if (line.startsWith(JBANG_DEPS_START)) {
            String[] parts;
            line = line.substring(JBANG_DEPS_START.length()).trim();
            line = line.trim();
            for (String part : parts = StringQuoteHelper.splitSafeQuote((String)line, (char)' ', (boolean)false)) {
                if ((part = part.trim()).endsWith("@pom")) continue;
                if (part.contains("${") && part.contains("}")) {
                    String target = StringHelper.between((String)part, (String)"${", (String)"}");
                    String value = StringHelper.before((String)target, (String)":", (String)target);
                    if (target.contains(":")) {
                        String def = StringHelper.after((String)target, (String)":");
                        value = System.getProperty(value, def);
                    } else {
                        String found = System.getProperty(value);
                        if (found == null) {
                            throw new IllegalArgumentException("Cannot find JVM system property: " + value + " for dependency: " + part);
                        }
                        value = found;
                    }
                    part = part.replace("${" + target + "}", value);
                }
                String dep = part;
                CamelContextCustomizer customizer = camelContext -> {
                    for (DependencyStrategy ds : camelContext.getRegistry().findByType(DependencyStrategy.class)) {
                        ds.onDependency(dep);
                    }
                };
                answer.add(customizer);
            }
        }
        return answer;
    }

    private static String removeLeadingComments(String line) {
        if (line == null) {
            return null;
        }
        line = line.trim();
        while (!line.startsWith(JBANG_DEPS_START) && line.startsWith("/") || line.startsWith("#")) {
            line = line.substring(1);
        }
        line = line.trim();
        return line;
    }
}

