/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.dozer;

import java.lang.reflect.Field;
import java.util.Map;
import javax.el.ExpressionFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.component.dozer.DozerEndpoint;
import org.apache.camel.converter.dozer.DozerBeanMapperConfiguration;
import org.apache.camel.converter.dozer.DozerThreadContextClassLoader;
import org.apache.camel.util.ReflectionHelper;
import org.dozer.CustomConverter;
import org.dozer.DozerBeanMapperBuilder;
import org.dozer.DozerEventListener;
import org.dozer.Mapper;
import org.dozer.config.BeanContainer;
import org.dozer.config.GlobalSettings;
import org.dozer.loader.api.BeanMappingBuilder;
import org.dozer.loader.xml.ELEngine;
import org.dozer.loader.xml.ElementReader;
import org.dozer.loader.xml.ExpressionElementReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapperFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MapperFactory.class);
    private final CamelContext camelContext;
    private final DozerBeanMapperConfiguration configuration;

    public MapperFactory(CamelContext camelContext, DozerBeanMapperConfiguration configuration) {
        this.camelContext = camelContext;
        this.configuration = configuration;
    }

    public Mapper create() {
        if (this.camelContext == null) {
            throw new IllegalStateException("CamelContext is null");
        }
        return this.parseConfiguration(this.configuration);
    }

    private Mapper parseConfiguration(DozerBeanMapperConfiguration configuration) {
        DozerBeanMapperBuilder builder = DozerBeanMapperBuilder.create();
        if (configuration != null) {
            if (configuration.getMappingFiles() != null) {
                String[] files = configuration.getMappingFiles().toArray(new String[configuration.getMappingFiles().size()]);
                builder.withMappingFiles(files);
            }
            if (configuration.getCustomConverters() != null) {
                for (CustomConverter customConverter : configuration.getCustomConverters()) {
                    builder.withCustomConverter(customConverter);
                }
            }
            if (configuration.getEventListeners() != null) {
                for (DozerEventListener dozerEventListener : configuration.getEventListeners()) {
                    builder.withEventListener(dozerEventListener);
                }
            }
            if (configuration.getCustomConvertersWithId() != null) {
                for (Map.Entry entry : configuration.getCustomConvertersWithId().entrySet()) {
                    builder.withCustomConverterWithId((String)entry.getKey(), (CustomConverter)entry.getValue());
                }
            }
            if (configuration.getBeanMappingBuilders() != null) {
                for (BeanMappingBuilder beanMappingBuilder : configuration.getBeanMappingBuilders()) {
                    builder.withMappingBuilder(beanMappingBuilder);
                }
            }
            if (configuration.getCustomFieldMapper() != null) {
                builder.withCustomFieldMapper(configuration.getCustomFieldMapper());
            }
        }
        Mapper mapper = builder.build();
        this.configureGlobalSettings(mapper);
        this.configureBeanContainer(mapper, configuration);
        mapper.getMappingMetadata();
        return mapper;
    }

    private void configureGlobalSettings(Mapper mapper) {
        GlobalSettings settings;
        Field field;
        try {
            LOG.info("Attempting to retrieve GlobalSettings from: " + mapper);
            field = mapper.getClass().getDeclaredField("globalSettings");
            field.setAccessible(true);
            settings = (GlobalSettings)field.get(mapper);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot retrieve Dozer GlobalSettings due " + e.getMessage(), e);
        }
        if (settings == null) {
            throw new IllegalStateException("Cannot retrieve Dozer GlobalSettings due null reflection response");
        }
        try {
            LOG.info("Configuring GlobalSettings to use Camel classloader: {}", (Object)DozerThreadContextClassLoader.class.getName());
            field = settings.getClass().getDeclaredField("classLoaderBeanName");
            ReflectionHelper.setField((Field)field, (Object)settings, (Object)DozerThreadContextClassLoader.class.getName());
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot configure Dozer GlobalSettings to use DozerThreadContextClassLoader as classloader due " + e.getMessage(), e);
        }
        try {
            LOG.info("Configuring GlobalSettings to enable EL");
            field = settings.getClass().getDeclaredField("elEnabled");
            ReflectionHelper.setField((Field)field, (Object)settings, (Object)true);
        }
        catch (NoSuchFieldException nsfEx) {
            throw new IllegalStateException("Failed to enable EL in global Dozer settings", nsfEx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureBeanContainer(Mapper mapper, DozerBeanMapperConfiguration configuration) {
        String elprop = System.getProperty("javax.el.ExpressionFactory");
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader appcl = this.camelContext.getApplicationContextClassLoader();
            ClassLoader auxcl = appcl != null ? appcl : DozerEndpoint.class.getClassLoader();
            Thread.currentThread().setContextClassLoader(auxcl);
            try {
                Class<?> clazz = auxcl.loadClass("com.sun.el.ExpressionFactoryImpl");
                ExpressionFactory factory = (ExpressionFactory)clazz.newInstance();
                System.setProperty("javax.el.ExpressionFactory", factory.getClass().getName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                LOG.debug("Cannot load glasfish expression engine, using default");
            }
            BeanContainer beanContainer = this.resolveBeanContainer(mapper);
            if (beanContainer.getElEngine() == null) {
                ELEngine engine = new ELEngine();
                engine.init();
                beanContainer.setElEngine(engine);
            }
            beanContainer.setElementReader((ElementReader)new ExpressionElementReader(beanContainer.getElEngine()));
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
            if (elprop == null) {
                System.clearProperty("javax.el.ExpressionFactory");
            } else {
                System.setProperty("javax.el.ExpressionFactory", elprop);
            }
        }
    }

    private BeanContainer resolveBeanContainer(Mapper mapper) {
        LOG.info("Attempting to retrieve BeanContainer from: " + mapper);
        BeanContainer beanContainer = (BeanContainer)MapperFactory.resolveProperty(mapper, "beanContainer");
        if (beanContainer == null) {
            throw new IllegalStateException("Cannot retrieve Dozer BeanContainer due null response");
        }
        return beanContainer;
    }

    private static Object resolveProperty(Mapper mapper, String fieldName) {
        Object prop;
        try {
            Field field = mapper.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            prop = field.get(mapper);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot retrieve DozerBeanMapper." + fieldName + " due " + e.getMessage(), e);
        }
        return prop;
    }
}

