/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.docling;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class DoclingEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":operationId";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Map<String, String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "docling".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "operationId", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Map<String, String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(39);
        props.add("apiKeyHeader");
        props.add("apiTimeout");
        props.add("asyncPollInterval");
        props.add("asyncTimeout");
        props.add("authenticationScheme");
        props.add("authenticationToken");
        props.add("batchFailOnFirstError");
        props.add("batchParallelism");
        props.add("batchSize");
        props.add("batchTimeout");
        props.add("connectionRequestTimeout");
        props.add("connectionTimeToLive");
        props.add("connectionTimeout");
        props.add("contentInBody");
        props.add("convertEndpoint");
        props.add("doclingCommand");
        props.add("doclingServeUrl");
        props.add("enableOCR");
        props.add("evictIdleConnections");
        props.add("extractAllMetadata");
        props.add("includeLayoutInfo");
        props.add("includeMetadataInHeaders");
        props.add("includeRawMetadata");
        props.add("lazyStartProducer");
        props.add("maxConnectionsPerRoute");
        props.add("maxFileSize");
        props.add("maxIdleTime");
        props.add("maxTotalConnections");
        props.add("ocrLanguage");
        props.add("operation");
        props.add("operationId");
        props.add("outputFormat");
        props.add("processTimeout");
        props.add("socketTimeout");
        props.add("splitBatchResults");
        props.add("useAsyncMode");
        props.add("useDoclingServe");
        props.add("validateAfterInactivity");
        props.add("workingDirectory");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(1);
        secretProps.add("authenticationToken");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        MULTI_VALUE_PREFIXES = Collections.emptyMap();
    }
}

