/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.docling;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.docling.DoclingComponent;
import org.apache.camel.component.docling.DoclingConfiguration;
import org.apache.camel.component.docling.DoclingHeaders;
import org.apache.camel.component.docling.DoclingProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="4.15.0", scheme="docling", title="Docling", syntax="docling:operationId", category={Category.TRANSFORMATION, Category.AI}, headersClass=DoclingHeaders.class, producerOnly=true)
public class DoclingEndpoint
extends DefaultEndpoint {
    @Metadata(required=true)
    @UriPath(description="The operation identifier")
    private final String operationId;
    @UriParam
    private DoclingConfiguration configuration;

    public DoclingEndpoint(String uri, DoclingComponent component, String operationId, DoclingConfiguration configuration) {
        super(uri, (Component)component);
        this.operationId = operationId;
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new DoclingProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported for Docling component");
    }

    public String getOperationId() {
        return this.operationId;
    }

    public DoclingConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(DoclingConfiguration configuration) {
        this.configuration = configuration;
    }
}

