/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.docling;

public class ConversionStatus {
    private final String taskId;
    private final Status status;
    private final String result;
    private final String errorMessage;
    private final Integer progress;

    public ConversionStatus(String taskId, Status status) {
        this(taskId, status, null, null, null);
    }

    public ConversionStatus(String taskId, Status status, String result, String errorMessage, Integer progress) {
        this.taskId = taskId;
        this.status = status;
        this.result = result;
        this.errorMessage = errorMessage;
        this.progress = progress;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getResult() {
        return this.result;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Integer getProgress() {
        return this.progress;
    }

    public boolean isCompleted() {
        return this.status == Status.COMPLETED;
    }

    public boolean isFailed() {
        return this.status == Status.FAILED;
    }

    public boolean isInProgress() {
        return this.status == Status.IN_PROGRESS || this.status == Status.PENDING;
    }

    public String toString() {
        return "ConversionStatus{taskId='" + this.taskId + "', status=" + String.valueOf((Object)this.status) + ", progress=" + this.progress + ", errorMessage='" + this.errorMessage + "'}";
    }

    public static enum Status {
        PENDING,
        IN_PROGRESS,
        COMPLETED,
        FAILED,
        UNKNOWN;

    }
}

