/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.docling;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.component.docling.BatchConversionResult;

public class BatchProcessingResults {
    private List<BatchConversionResult> results;
    private int totalDocuments;
    private int successCount;
    private int failureCount;
    private long totalProcessingTimeMs;
    private long startTimeMs;
    private long endTimeMs;

    public BatchProcessingResults() {
        this.results = new ArrayList<BatchConversionResult>();
    }

    public BatchProcessingResults(List<BatchConversionResult> results) {
        this.results = results != null ? results : new ArrayList();
        this.updateCounts();
    }

    public List<BatchConversionResult> getResults() {
        return this.results;
    }

    public void setResults(List<BatchConversionResult> results) {
        this.results = results;
        this.updateCounts();
    }

    public void addResult(BatchConversionResult result) {
        this.results.add(result);
        this.updateCounts();
    }

    public List<BatchConversionResult> getSuccessful() {
        return this.results.stream().filter(BatchConversionResult::isSuccess).collect(Collectors.toList());
    }

    public List<BatchConversionResult> getFailed() {
        return this.results.stream().filter(r -> !r.isSuccess()).collect(Collectors.toList());
    }

    public int getTotalDocuments() {
        return this.totalDocuments;
    }

    public void setTotalDocuments(int totalDocuments) {
        this.totalDocuments = totalDocuments;
    }

    public int getSuccessCount() {
        return this.successCount;
    }

    public void setSuccessCount(int successCount) {
        this.successCount = successCount;
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    public void setFailureCount(int failureCount) {
        this.failureCount = failureCount;
    }

    public long getTotalProcessingTimeMs() {
        return this.totalProcessingTimeMs;
    }

    public void setTotalProcessingTimeMs(long totalProcessingTimeMs) {
        this.totalProcessingTimeMs = totalProcessingTimeMs;
    }

    public long getStartTimeMs() {
        return this.startTimeMs;
    }

    public void setStartTimeMs(long startTimeMs) {
        this.startTimeMs = startTimeMs;
    }

    public long getEndTimeMs() {
        return this.endTimeMs;
    }

    public void setEndTimeMs(long endTimeMs) {
        this.endTimeMs = endTimeMs;
        if (this.startTimeMs > 0L) {
            this.totalProcessingTimeMs = endTimeMs - this.startTimeMs;
        }
    }

    public boolean isAllSuccessful() {
        return this.failureCount == 0 && this.totalDocuments > 0;
    }

    public boolean hasAnySuccessful() {
        return this.successCount > 0;
    }

    public boolean hasAnyFailures() {
        return this.failureCount > 0;
    }

    public double getSuccessRate() {
        if (this.totalDocuments == 0) {
            return 0.0;
        }
        return (double)this.successCount * 100.0 / (double)this.totalDocuments;
    }

    private void updateCounts() {
        this.totalDocuments = this.results.size();
        this.successCount = (int)this.results.stream().filter(BatchConversionResult::isSuccess).count();
        this.failureCount = this.totalDocuments - this.successCount;
    }

    public String toString() {
        return "BatchProcessingResults{totalDocuments=" + this.totalDocuments + ", successCount=" + this.successCount + ", failureCount=" + this.failureCount + ", totalProcessingTimeMs=" + this.totalProcessingTimeMs + ", successRate=" + String.format("%.2f%%", this.getSuccessRate()) + "}";
    }
}

