/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.docling;

import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.docling.DoclingOperations;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@Configurer
@UriParams
public class DoclingConfiguration
implements Cloneable {
    @UriParam
    @Metadata(required=true, defaultValue="CONVERT_TO_MARKDOWN", description="The operation to perform", enums="CONVERT_TO_MARKDOWN,CONVERT_TO_HTML,CONVERT_TO_JSON,EXTRACT_TEXT,EXTRACT_STRUCTURED_DATA")
    private DoclingOperations operation = DoclingOperations.CONVERT_TO_MARKDOWN;
    @UriParam(label="advanced")
    @Metadata(description="Path to Docling Python executable or command")
    private String doclingCommand = "docling";
    @UriParam(label="advanced")
    @Metadata(description="Working directory for Docling execution")
    private String workingDirectory;
    @UriParam
    @Metadata(description="Enable OCR processing for scanned documents", defaultValue="true")
    private boolean enableOCR = true;
    @UriParam
    @Metadata(description="Language code for OCR processing", defaultValue="en", enums="en,es,fr,de,it,pt,ru,zh,ja,ko,ar,hi,th,vi,tr,pl,nl,sv,da,no,fi,cs,hu,el,he,fa,ur,bn,ta,te,ml,kn,gu,pa,or,as,ne,si,my,lo,km,ka,hy,eu,mt,is,ga,cy,gd,br,oc,ca,gl,ast,an,lad,la,eo,ia,ie,vo,jbo,tlh")
    private String ocrLanguage = "en";
    @UriParam
    @Metadata(description="Output format for document conversion", defaultValue="markdown", enums="md,json,html,html_split_page,text,doctags")
    private String outputFormat = "markdown";
    @UriParam(label="advanced")
    @Metadata(description="Timeout for Docling process execution in milliseconds", defaultValue="30000")
    private long processTimeout = 30000L;
    @UriParam
    @Metadata(description="Show layout information with bounding boxes", defaultValue="false")
    private boolean includeLayoutInfo = false;
    @UriParam(label="security")
    @Metadata(description="Maximum file size in bytes for processing", defaultValue="52428800")
    private long maxFileSize = 0x3200000L;
    @UriParam
    @Metadata(description="Include the content of the output file in the exchange body and delete the output file", defaultValue="false")
    private boolean contentInBody = false;

    public DoclingOperations getOperation() {
        return this.operation;
    }

    public void setOperation(DoclingOperations operation) {
        this.operation = operation;
    }

    public String getDoclingCommand() {
        return this.doclingCommand;
    }

    public void setDoclingCommand(String doclingCommand) {
        this.doclingCommand = doclingCommand;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public boolean isEnableOCR() {
        return this.enableOCR;
    }

    public void setEnableOCR(boolean enableOCR) {
        this.enableOCR = enableOCR;
    }

    public String getOcrLanguage() {
        return this.ocrLanguage;
    }

    public void setOcrLanguage(String ocrLanguage) {
        this.ocrLanguage = ocrLanguage;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public long getProcessTimeout() {
        return this.processTimeout;
    }

    public void setProcessTimeout(long processTimeout) {
        this.processTimeout = processTimeout;
    }

    public boolean isIncludeLayoutInfo() {
        return this.includeLayoutInfo;
    }

    public void setIncludeLayoutInfo(boolean includeLayoutInfo) {
        this.includeLayoutInfo = includeLayoutInfo;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public boolean isContentInBody() {
        return this.contentInBody;
    }

    public void setContentInBody(boolean contentInBody) {
        this.contentInBody = contentInBody;
    }

    public DoclingConfiguration copy() {
        try {
            return (DoclingConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

