/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.djl.model.audio;

import ai.djl.Model;
import ai.djl.inference.Predictor;
import ai.djl.modality.audio.Audio;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConversionException;
import org.apache.camel.component.djl.DJLEndpoint;
import org.apache.camel.component.djl.model.AbstractPredictor;

public class CustomAudioPredictor
extends AbstractPredictor {
    protected final String modelName;
    protected final String translatorName;

    public CustomAudioPredictor(DJLEndpoint endpoint) {
        super(endpoint);
        this.modelName = endpoint.getModel();
        this.translatorName = endpoint.getTranslator();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        try {
            Audio audio = (Audio)exchange.getIn().getBody(Audio.class);
            String result = this.predict(exchange, audio);
            exchange.getIn().setBody((Object)result);
        }
        catch (TypeConversionException e) {
            throw new RuntimeCamelException("Data type is not supported. Body should be ai.djl.modality.audio.Audio, byte[], InputStream or File");
        }
    }

    protected String predict(Exchange exchange, Audio audio) {
        String string;
        block8: {
            Model model = (Model)exchange.getContext().getRegistry().lookupByNameAndType(this.modelName, Model.class);
            Translator translator = (Translator)exchange.getContext().getRegistry().lookupByNameAndType(this.translatorName, Translator.class);
            exchange.getIn().setHeader("CamelDjlInput", (Object)audio);
            Predictor predictor = model.newPredictor(translator);
            try {
                string = (String)predictor.predict((Object)audio);
                if (predictor == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (predictor != null) {
                        try {
                            predictor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (TranslateException e) {
                    throw new RuntimeCamelException("Could not process input or output", (Throwable)e);
                }
            }
            predictor.close();
        }
        return string;
    }
}

