/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.djl.model.timeseries;

import ai.djl.Model;
import ai.djl.inference.Predictor;
import ai.djl.timeseries.Forecast;
import ai.djl.timeseries.TimeSeriesData;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.djl.DJLEndpoint;
import org.apache.camel.component.djl.model.AbstractPredictor;

public class CustomForecastingPredictor
extends AbstractPredictor {
    protected final String modelName;
    protected final String translatorName;

    public CustomForecastingPredictor(DJLEndpoint endpoint) {
        super(endpoint);
        this.modelName = endpoint.getModel();
        this.translatorName = endpoint.getTranslator();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        if (!(exchange.getIn().getBody() instanceof TimeSeriesData)) {
            throw new RuntimeCamelException("Data type is not supported. Body should be TimeSeriesData");
        }
        TimeSeriesData input = (TimeSeriesData)exchange.getIn().getBody(TimeSeriesData.class);
        Forecast result = this.predict(exchange, input);
        exchange.getIn().setBody((Object)result);
    }

    protected Forecast predict(Exchange exchange, TimeSeriesData input) {
        Forecast forecast;
        block8: {
            Model model = (Model)exchange.getContext().getRegistry().lookupByNameAndType(this.modelName, Model.class);
            Translator translator = (Translator)exchange.getContext().getRegistry().lookupByNameAndType(this.translatorName, Translator.class);
            exchange.getIn().setHeader("CamelDjlInput", (Object)input);
            Predictor predictor = model.newPredictor(translator);
            try {
                forecast = (Forecast)predictor.predict((Object)input);
                if (predictor == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (predictor != null) {
                        try {
                            predictor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (TranslateException e) {
                    throw new RuntimeCamelException("Could not process input or output", (Throwable)e);
                }
            }
            predictor.close();
        }
        return forecast;
    }
}

