/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.djl.model.tabular;

import ai.djl.Model;
import ai.djl.inference.Predictor;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.djl.DJLEndpoint;
import org.apache.camel.component.djl.model.AbstractPredictor;

public class CustomTabularPredictor
extends AbstractPredictor {
    protected final String modelName;
    protected final String translatorName;

    public CustomTabularPredictor(DJLEndpoint endpoint) {
        super(endpoint);
        this.modelName = endpoint.getModel();
        this.translatorName = endpoint.getTranslator();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Object input = exchange.getIn().getBody();
        Object result = this.predict(exchange, input);
        exchange.getIn().setBody(result);
    }

    protected Object predict(Exchange exchange, Object input) {
        Object object;
        block8: {
            Model model = (Model)exchange.getContext().getRegistry().lookupByNameAndType(this.modelName, Model.class);
            Translator translator = (Translator)exchange.getContext().getRegistry().lookupByNameAndType(this.translatorName, Translator.class);
            exchange.getIn().setHeader("CamelDjlInput", input);
            Predictor predictor = model.newPredictor(translator);
            try {
                object = predictor.predict(input);
                if (predictor == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (predictor != null) {
                        try {
                            predictor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (TranslateException e) {
                    throw new RuntimeCamelException("Could not process input or output", (Throwable)e);
                }
            }
            predictor.close();
        }
        return object;
    }
}

