/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dhis2;

import org.apache.camel.component.dhis2.internal.Dhis2ApiName;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.hisp.dhis.integration.sdk.api.Dhis2Client;

@UriParams
@Configurer
public class Dhis2Configuration {
    @UriParam(description="DHIS2 server base API URL (e.g., https://play.dhis2.org/2.39.1.1/api)")
    private String baseApiUrl;
    @UriParam(description="Username of the DHIS2 user to operate as", secret=true, label="security")
    private String username;
    @UriParam(description="Password of the DHIS2 username", secret=true, label="security")
    private String password;
    @UriParam(description="Personal access token to authenticate with DHIS2. This option is mutually exclusive to username and password", secret=true, label="security")
    private String personalAccessToken;
    @UriPath(description="API operation (e.g., get)")
    @Metadata(required=true)
    private Dhis2ApiName apiName;
    @UriPath(description="Subject of the API operation (e.g., resource)")
    @Metadata(required=true)
    private String methodName;
    @UriParam(label="advanced", description="References a user-defined org.hisp.dhis.integration.sdk.api.Dhis2Client. This option is mutually exclusive to the baseApiUrl, username, password, and personalAccessToken options")
    private Dhis2Client client;

    public String getBaseApiUrl() {
        return this.baseApiUrl;
    }

    public void setBaseApiUrl(String baseApiUrl) {
        this.baseApiUrl = baseApiUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Dhis2ApiName getApiName() {
        return this.apiName;
    }

    public void setApiName(Dhis2ApiName apiName) {
        this.apiName = apiName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getPersonalAccessToken() {
        return this.personalAccessToken;
    }

    public void setPersonalAccessToken(String personalAccessToken) {
        this.personalAccessToken = personalAccessToken;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Dhis2Client getClient() {
        return this.client;
    }

    public void setClient(Dhis2Client dhis2Client) {
        this.client = dhis2Client;
    }
}

