/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dhis2;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.dhis2.Dhis2Configuration;
import org.apache.camel.component.dhis2.Dhis2Endpoint;
import org.apache.camel.component.dhis2.internal.Dhis2ApiCollection;
import org.apache.camel.component.dhis2.internal.Dhis2ApiName;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.component.AbstractApiComponent;
import org.apache.camel.support.component.ApiCollection;
import org.apache.camel.util.ObjectHelper;
import org.hisp.dhis.integration.sdk.Dhis2ClientBuilder;
import org.hisp.dhis.integration.sdk.api.Dhis2Client;

@Component(value="dhis2")
public class Dhis2Component
extends AbstractApiComponent<Dhis2ApiName, Dhis2Configuration, Dhis2ApiCollection> {
    @Metadata(label="advanced")
    Dhis2Configuration configuration;
    private Dhis2Client dhis2Client;

    public Dhis2Component() {
        super(Dhis2ApiName.class, (ApiCollection)Dhis2ApiCollection.getCollection());
    }

    public Dhis2Component(CamelContext context) {
        super(context, Dhis2ApiName.class, (ApiCollection)Dhis2ApiCollection.getCollection());
    }

    protected Dhis2ApiName getApiName(String apiNameStr) throws IllegalArgumentException {
        return (Dhis2ApiName)((Object)this.getCamelContext().getTypeConverter().convertTo(Dhis2ApiName.class, (Object)apiNameStr));
    }

    protected Endpoint createEndpoint(String uri, String methodName, Dhis2ApiName apiName, Dhis2Configuration endpointConfiguration) {
        endpointConfiguration.setApiName(apiName);
        endpointConfiguration.setMethodName(methodName);
        return new Dhis2Endpoint(uri, this, apiName, methodName, endpointConfiguration);
    }

    public void setConfiguration(Dhis2Configuration configuration) {
        super.setConfiguration((Object)configuration);
    }

    public Dhis2Client getClient(Dhis2Configuration endpointConfiguration) {
        if (endpointConfiguration.equals(this.configuration)) {
            this.lock.lock();
            try {
                if (this.dhis2Client == null) {
                    this.dhis2Client = Dhis2ClientBuilder.newClient((String)endpointConfiguration.getBaseApiUrl(), (String)endpointConfiguration.getUsername(), (String)endpointConfiguration.getPassword()).build();
                }
            }
            finally {
                this.lock.unlock();
            }
            return this.dhis2Client;
        }
        if (endpointConfiguration.getClient() != null) {
            if (endpointConfiguration.getBaseApiUrl() != null || endpointConfiguration.getPersonalAccessToken() != null || endpointConfiguration.getUsername() != null || endpointConfiguration.getPassword() != null) {
                throw new RuntimeCamelException("Bad DHIS2 endpoint configuration: client option is mutually exclusive to baseApiUrl, username, password, and personalAccessToken. Either set (1) `client`, or (2) `baseApiUrl` and `username` and `password`, or (3) `baseApiUrl` and `personalAccessToken`");
            }
            return endpointConfiguration.getClient();
        }
        if (ObjectHelper.isNotEmpty((String)endpointConfiguration.getPersonalAccessToken()) && (ObjectHelper.isNotEmpty((String)endpointConfiguration.getUsername()) || ObjectHelper.isNotEmpty((String)endpointConfiguration.getPassword()))) {
            throw new RuntimeCamelException("Bad DHIS2 authentication configuration: Personal access token authentication and basic authentication are mutually exclusive. Either set `personalAccessToken` or both `username` and `password`");
        }
        if (ObjectHelper.isNotEmpty((String)endpointConfiguration.getPersonalAccessToken())) {
            return Dhis2ClientBuilder.newClient((String)endpointConfiguration.getBaseApiUrl(), (String)endpointConfiguration.getPersonalAccessToken()).build();
        }
        return Dhis2ClientBuilder.newClient((String)endpointConfiguration.getBaseApiUrl(), (String)endpointConfiguration.getUsername(), (String)endpointConfiguration.getPassword()).build();
    }
}

