/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dapr;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.dapr.DaprConfiguration;
import org.apache.camel.component.dapr.DaprConfigurationOptionsProxy;
import org.apache.camel.component.dapr.DaprEndpoint;
import org.apache.camel.component.dapr.operations.DaprOperationManager;
import org.apache.camel.component.dapr.operations.DaprOperationResponse;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaprProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(DaprProducer.class);
    private final DaprConfigurationOptionsProxy configurationOptionsProxy;
    private final DaprOperationManager manager;

    public DaprProducer(Endpoint endpoint, DaprConfiguration configuration) {
        super(endpoint);
        this.configurationOptionsProxy = new DaprConfigurationOptionsProxy(configuration);
        this.manager = new DaprOperationManager(this.configurationOptionsProxy);
    }

    public void process(Exchange exchange) throws Exception {
        LOG.debug("Processing operation: {}", (Object)this.configurationOptionsProxy.getOperation());
        this.setResponse(exchange, this.manager.process(exchange, this.getEndpoint().getClient()));
    }

    private void setResponse(Exchange exchange, DaprOperationResponse response) {
        if (response != null) {
            exchange.getMessage().setBody(response.getBody());
            exchange.getMessage().setHeaders(response.getHeaders());
        }
    }

    public DaprEndpoint getEndpoint() {
        return (DaprEndpoint)super.getEndpoint();
    }
}

