/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dapr.operations;

import io.dapr.client.DaprClient;
import io.dapr.client.domain.DeleteStateRequest;
import io.dapr.client.domain.ExecuteStateTransactionRequest;
import io.dapr.client.domain.GetBulkStateRequest;
import io.dapr.client.domain.GetStateRequest;
import io.dapr.client.domain.SaveStateRequest;
import io.dapr.client.domain.State;
import io.dapr.client.domain.StateOptions;
import io.dapr.client.domain.TransactionalStateOperation;
import io.dapr.utils.TypeRef;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.dapr.DaprConfigurationOptionsProxy;
import org.apache.camel.component.dapr.StateOperation;
import org.apache.camel.component.dapr.operations.DaprOperationHandler;
import org.apache.camel.component.dapr.operations.DaprOperationResponse;
import org.apache.camel.util.ObjectHelper;

public class DaprStateHandler
implements DaprOperationHandler {
    private final DaprConfigurationOptionsProxy configurationOptionsProxy;

    public DaprStateHandler(DaprConfigurationOptionsProxy configurationOptionsProxy) {
        this.configurationOptionsProxy = configurationOptionsProxy;
    }

    @Override
    public DaprOperationResponse handle(Exchange exchange, DaprClient client) {
        StateOperation stateOperation = this.configurationOptionsProxy.getStateOperation(exchange);
        switch (stateOperation) {
            case save: {
                return this.saveState(exchange, client);
            }
            case saveBulk: {
                return this.saveBulkState(exchange, client);
            }
            case get: {
                return this.getState(exchange, client);
            }
            case getBulk: {
                return this.getBulkState(exchange, client);
            }
            case delete: {
                return this.deleteState(exchange, client);
            }
            case executeTransaction: {
                return this.executeStateTransaction(exchange, client);
            }
        }
        throw new IllegalArgumentException("Unsupported state operation");
    }

    private DaprOperationResponse saveState(Exchange exchange, DaprClient client) {
        Object payload = exchange.getIn().getBody();
        String stateStore = this.configurationOptionsProxy.getStateStore(exchange);
        String key = this.configurationOptionsProxy.getKey(exchange);
        String eTag = this.configurationOptionsProxy.getETag(exchange);
        StateOptions stateOptions = this.getStateOptions(exchange);
        client.saveState(stateStore, key, eTag, payload, stateOptions).block();
        return DaprOperationResponse.create(new State(key, payload, eTag, stateOptions));
    }

    private DaprOperationResponse saveBulkState(Exchange exchange, DaprClient client) {
        String stateStore = this.configurationOptionsProxy.getStateStore(exchange);
        List<State<?>> states = this.configurationOptionsProxy.getStates(exchange);
        SaveStateRequest stateRequest = new SaveStateRequest(stateStore);
        stateRequest.setStates(states);
        client.saveBulkState(stateRequest);
        return DaprOperationResponse.create(stateRequest);
    }

    private DaprOperationResponse getState(Exchange exchange, DaprClient client) {
        String stateStore = this.configurationOptionsProxy.getStateStore(exchange);
        String key = this.configurationOptionsProxy.getKey(exchange);
        Map<String, String> metadata = this.configurationOptionsProxy.getMetadata(exchange);
        StateOptions stateOptions = this.getStateOptions(exchange);
        GetStateRequest stateRequest = new GetStateRequest(stateStore, key);
        stateRequest.setMetadata(metadata);
        stateRequest.setStateOptions(stateOptions);
        State response = (State)client.getState(stateRequest, TypeRef.get(byte[].class)).block();
        return DaprOperationResponse.create(response);
    }

    private DaprOperationResponse getBulkState(Exchange exchange, DaprClient client) {
        String stateStore = this.configurationOptionsProxy.getStateStore(exchange);
        List<String> keys = this.configurationOptionsProxy.getKeys(exchange);
        Map<String, String> metadata = this.configurationOptionsProxy.getMetadata(exchange);
        GetBulkStateRequest stateRequest = new GetBulkStateRequest(stateStore, keys);
        stateRequest.setMetadata(metadata);
        List response = (List)client.getBulkState(stateRequest, TypeRef.get(byte[].class)).block();
        return DaprOperationResponse.create(response);
    }

    private DaprOperationResponse deleteState(Exchange exchange, DaprClient client) {
        String stateStore = this.configurationOptionsProxy.getStateStore(exchange);
        String key = this.configurationOptionsProxy.getKey(exchange);
        String eTag = this.configurationOptionsProxy.getETag(exchange);
        Map<String, String> metadata = this.configurationOptionsProxy.getMetadata(exchange);
        StateOptions stateOptions = this.getStateOptions(exchange);
        DeleteStateRequest stateRequest = new DeleteStateRequest(stateStore, key);
        stateRequest.setEtag(eTag);
        stateRequest.setMetadata(metadata);
        stateRequest.setStateOptions(stateOptions);
        client.deleteState(stateRequest).block();
        return DaprOperationResponse.create(stateRequest);
    }

    private DaprOperationResponse executeStateTransaction(Exchange exchange, DaprClient client) {
        String stateStore = this.configurationOptionsProxy.getStateStore(exchange);
        List<TransactionalStateOperation<?>> transactions = this.configurationOptionsProxy.getTransactions(exchange);
        Map<String, String> metadata = this.configurationOptionsProxy.getMetadata(exchange);
        ExecuteStateTransactionRequest stateRequest = new ExecuteStateTransactionRequest(stateStore);
        stateRequest.setOperations(transactions);
        stateRequest.setMetadata(metadata);
        client.executeStateTransaction(stateRequest);
        return DaprOperationResponse.create(stateRequest);
    }

    private StateOptions getStateOptions(Exchange exchange) {
        StateOptions.Concurrency concurrency = this.configurationOptionsProxy.getConcurrency(exchange);
        StateOptions.Consistency consistency = this.configurationOptionsProxy.getConsistency(exchange);
        StateOptions stateOptions = null;
        if (concurrency != null || consistency != null) {
            stateOptions = new StateOptions(consistency, concurrency);
        }
        return stateOptions;
    }

    @Override
    public void validateConfiguration(Exchange exchange) {
        String stateStore = this.configurationOptionsProxy.getStateStore(exchange);
        String key = this.configurationOptionsProxy.getKey(exchange);
        StateOperation stateOperation = this.configurationOptionsProxy.getStateOperation(exchange);
        if (ObjectHelper.isEmpty((String)stateStore)) {
            throw new IllegalArgumentException("State store not configured");
        }
        switch (stateOperation) {
            case save: {
                Object payload = exchange.getIn().getBody();
                if (!ObjectHelper.isEmpty((String)key) && !ObjectHelper.isEmpty((Object)payload)) break;
                throw new IllegalArgumentException("Key and payload must not be empty for 'save' operation");
            }
            case saveBulk: {
                List<State<?>> states = this.configurationOptionsProxy.getStates(exchange);
                if (!ObjectHelper.isEmpty(states)) break;
                throw new IllegalArgumentException("States must not be empty for 'saveBulk' operation");
            }
            case get: 
            case delete: {
                if (!ObjectHelper.isEmpty((String)key)) break;
                throw new IllegalArgumentException("Key must not be empty for 'get' and 'delete' operations");
            }
            case getBulk: {
                List<String> keys = this.configurationOptionsProxy.getKeys(exchange);
                if (!ObjectHelper.isEmpty(keys)) break;
                throw new IllegalArgumentException("Keys must not be empty for 'getBulk' operation");
            }
            case executeTransaction: {
                List<TransactionalStateOperation<?>> transactions = this.configurationOptionsProxy.getTransactions(exchange);
                if (!ObjectHelper.isEmpty(transactions)) break;
                throw new IllegalArgumentException("Transactions must not be empty for 'executeTransaction' operation");
            }
            default: {
                throw new IllegalArgumentException("Unsupported state operation");
            }
        }
    }
}

