/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dapr;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.dapr.DaprConfiguration;
import org.apache.camel.component.dapr.DaprEndpoint;
import org.apache.camel.component.dapr.DaprOperation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="dapr")
public class DaprComponent
extends DefaultComponent {
    @Metadata
    private DaprConfiguration configuration = new DaprConfiguration();

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.isBlank()) {
            throw new IllegalArgumentException("Operation name must be specified.");
        }
        DaprConfiguration config = this.configuration != null ? this.configuration.copy() : new DaprConfiguration();
        config.setOperation(DaprOperation.valueOf(remaining));
        DaprEndpoint endpoint = new DaprEndpoint(uri, this, config);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    public DaprConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(DaprConfiguration configuration) {
        this.configuration = configuration;
    }
}

