/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dapr.operations;

import io.dapr.client.DaprClient;
import io.dapr.client.DaprHttp;
import io.dapr.client.domain.HttpExtension;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.dapr.DaprConfigurationOptionsProxy;
import org.apache.camel.component.dapr.operations.DaprOperationHandler;
import org.apache.camel.component.dapr.operations.DaprOperationResponse;
import org.apache.camel.util.ObjectHelper;

public class DaprServiceInvocationHandler
implements DaprOperationHandler {
    private final DaprConfigurationOptionsProxy configurationOptionsProxy;

    public DaprServiceInvocationHandler(DaprConfigurationOptionsProxy configurationOptionsProxy) {
        this.configurationOptionsProxy = configurationOptionsProxy;
    }

    @Override
    public DaprOperationResponse handle(Exchange exchange, DaprClient client) {
        Object payload = exchange.getIn().getBody();
        HttpExtension httpExtension = this.initHttpExtension(exchange);
        String service = this.configurationOptionsProxy.getServiceToInvoke(exchange);
        String method = this.configurationOptionsProxy.getMethodToInvoke(exchange);
        byte[] response = (byte[])client.invokeMethod(service, method, payload, httpExtension, byte[].class).block();
        return DaprOperationResponse.create(response);
    }

    private HttpExtension initHttpExtension(Exchange exchange) {
        HttpExtension httpExtension = this.configurationOptionsProxy.getHttpExtension(exchange);
        if (ObjectHelper.isEmpty((Object)httpExtension)) {
            String verb = this.configurationOptionsProxy.getVerb(exchange);
            Map<String, List<String>> queryParameters = this.configurationOptionsProxy.getQueryParameters(exchange);
            Map<String, String> httpHeaders = this.configurationOptionsProxy.getHttpHeaders(exchange);
            httpExtension = new HttpExtension(DaprHttp.HttpMethods.valueOf((String)verb), queryParameters, httpHeaders);
        }
        return httpExtension;
    }

    @Override
    public void validateConfiguration(Exchange exchange) {
        String serviceToInvoke = this.configurationOptionsProxy.getServiceToInvoke(exchange);
        String methodToInvoke = this.configurationOptionsProxy.getMethodToInvoke(exchange);
        if (ObjectHelper.isEmpty((String)serviceToInvoke) || ObjectHelper.isEmpty((String)methodToInvoke)) {
            throw new IllegalArgumentException("serviceToInvoke and methodToInvoke are mandatory to invoke a service");
        }
    }
}

