/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dapr.operations;

import io.dapr.client.DaprClient;
import io.dapr.client.domain.PublishEventRequest;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.dapr.DaprConfigurationOptionsProxy;
import org.apache.camel.component.dapr.operations.DaprOperationHandler;
import org.apache.camel.component.dapr.operations.DaprOperationResponse;
import org.apache.camel.util.ObjectHelper;

public class DaprPubSubHandler
implements DaprOperationHandler {
    private final DaprConfigurationOptionsProxy configurationOptionsProxy;

    public DaprPubSubHandler(DaprConfigurationOptionsProxy configurationOptionsProxy) {
        this.configurationOptionsProxy = configurationOptionsProxy;
    }

    @Override
    public DaprOperationResponse handle(Exchange exchange, DaprClient client) {
        Object payload = exchange.getIn().getBody();
        String pubSubName = this.configurationOptionsProxy.getPubSubName(exchange);
        String topic = this.configurationOptionsProxy.getTopic(exchange);
        String contentType = this.configurationOptionsProxy.getContentType(exchange);
        Map<String, String> metadata = this.configurationOptionsProxy.getMetadata(exchange);
        PublishEventRequest publishEventRequest = new PublishEventRequest(pubSubName, topic, payload);
        publishEventRequest.setContentType(contentType);
        publishEventRequest.setMetadata(metadata);
        client.publishEvent(publishEventRequest).block();
        return DaprOperationResponse.create(publishEventRequest);
    }

    @Override
    public void validateConfiguration(Exchange exchange) {
        String pubSubName = this.configurationOptionsProxy.getPubSubName(exchange);
        String topic = this.configurationOptionsProxy.getTopic(exchange);
        if (ObjectHelper.isEmpty((String)pubSubName) || ObjectHelper.isEmpty((String)topic)) {
            throw new IllegalArgumentException("pubSubName and topic are mandatory for publish operation");
        }
    }
}

