/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dapr.operations;

import io.dapr.client.domain.ConfigurationItem;
import java.util.HashMap;
import java.util.Map;

public class DaprOperationResponse {
    private Object body;
    private Map<String, Object> headers = new HashMap<String, Object>();

    private DaprOperationResponse(Object body) {
        this.body = body;
    }

    public DaprOperationResponse(Object body, Map<String, Object> headers) {
        this.body = body;
        this.headers = headers;
    }

    public static DaprOperationResponse create(Object body) {
        return new DaprOperationResponse(body);
    }

    public static DaprOperationResponse create(Object body, Map<String, Object> headers) {
        return new DaprOperationResponse(body, headers);
    }

    public static DaprOperationResponse createFromConfig(Map<String, ConfigurationItem> config) {
        Map<String, Object> responseHeaders = Map.of("CamelDaprRawConfigResponse", config);
        HashMap body = new HashMap();
        if (!config.isEmpty()) {
            config.forEach((k, v) -> body.put(k, v.getValue()));
        }
        return DaprOperationResponse.create(body, responseHeaders);
    }

    public Object getBody() {
        return this.body;
    }

    private void setBody(Object body) {
        this.body = body;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }
}

