/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dapr;

import org.apache.camel.spi.Metadata;

public class DaprConstants {
    private static final String HEADER_PREFIX = "CamelDapr";
    @Metadata(label="producer", description="Target service to invoke. Can be a Dapr App ID, a named HTTPEndpoint, or a FQDN/public URL", javaType="String")
    public static final String SERVICE_TO_INVOKE = "CamelDaprServiceToInvoke";
    @Metadata(label="producer", description="The name of the method or route to invoke on the target service", javaType="String")
    public static final String METHOD_TO_INVOKE = "CamelDaprMethodToInvoke";
    @Metadata(label="producer", description="The HTTP verb to use for service invocation", javaType="String")
    public static final String VERB = "CamelDaprVerb";
    @Metadata(label="producer", description="The query parameters for HTTP requests", javaType="Map<String, List<String>>")
    public static final String QUERY_PARAMETERS = "CamelDaprQueryParameters";
    @Metadata(label="producer", description="The headers for HTTP requests", javaType="Map<String, String>")
    public static final String HTTP_HEADERS = "CamelDaprHttpHeaders";
    @Metadata(label="producer", description="The HttpExtension object for service invocation. Takes precedence over verb", javaType="HttpExtension")
    public static final String HTTP_EXTENSION = "CamelDaprHttpExtension";
    @Metadata(label="producer", description="The state operation to perform on the state store. Required for DaprOperation.state operation", javaType="StateOperation", defaultValue="get", enums="save, saveBulk, get, getBulk, delete, executeTransaction")
    public static final String STATE_OPERATION = "CamelDaprStateOperation";
    @Metadata(label="producer", description="The name of the Dapr state store to interact with, defined in statestore.yaml config", javaType="String")
    public static final String STATE_STORE = "CamelDaprStateStore";
    @Metadata(label="producer", description="The name of the Dapr secret store to interact with, defined in local-secret-store.yaml config", javaType="String")
    public static final String SECRET_STORE = "CamelDaprSecretStore";
    @Metadata(label="producer", description="The name of the Dapr config store to interact with, defined in statestore.yaml config", javaType="String")
    public static final String CONFIG_STORE = "CamelDaprConfigStore";
    @Metadata(label="producer", description="The key used to identify the state/secret object within the specified state/secret store", javaType="String")
    public static final String KEY = "CamelDaprKey";
    @Metadata(label="producer", description="The eTag for optimistic concurrency during state save or delete operations", javaType="String")
    public static final String E_TAG = "CamelDaprETag";
    @Metadata(label="producer", description="Concurrency mode to use with state operations", javaType="io.dapr.client.domain.StateOptions.Concurrency")
    public static final String CONCURRENCY = "CamelDaprConcurrency";
    @Metadata(label="producer", description="Consistency level to use with state operations", javaType="io.dapr.client.domain.StateOptions.Consistency")
    public static final String CONSISTENCY = "CamelDaprConsistency";
    @Metadata(label="producer", description="Additional key-value pairs to be passed to the state store", javaType="Map<String, String>")
    public static final String METADATA = "CamelDaprMetadata";
    @Metadata(label="producer", description="List of states for bulk save operation", javaType="List<State<?>>")
    public static final String STATES = "CamelDaprStates";
    @Metadata(label="producer", description="List of keys for bulk get operation", javaType="List<String>")
    public static final String KEYS = "CamelDaprKeys";
    @Metadata(label="producer", description="List of transactions for execute transactions state operations", javaType="List<TransactionalStateOperation<?>>")
    public static final String TRANSACTIONS = "CamelDaprTransactions";
    @Metadata(label="common", description="The name of the Dapr Pub/Sub component to use. This identifies which underlying messaging system Dapr will interact with for publishing or subscribing to events.", javaType="String")
    public static final String PUBSUB_NAME = "CamelDaprPubSubName";
    @Metadata(label="common", description="The name of the topic to subscribe to. The topic must exist in the Pub/Sub component configured under the given pubsubName.", javaType="String")
    public static final String TOPIC = "CamelDaprTopic";
    @Metadata(label="common", description="The content type for the Pub/Sub component to use", javaType="String")
    public static final String CONTENT_TYPE = "CamelDaprContentType";
    @Metadata(label="consumer", description="Gets the unique identifier for the event, used to distinguish it from other events", javaType="String")
    public static final String ID = "CamelDaprID";
    @Metadata(label="consumer", description="Gets the origin of the event, typically a URI indicating the component or service that generated the event", javaType="String")
    public static final String SOURCE = "CamelDaprSource";
    @Metadata(label="consumer", description="Gets the string indicating the type of cloud event", javaType="String")
    public static final String TYPE = "CamelDaprType";
    @Metadata(label="consumer", description="Gets the version of the CloudEvents specification that the event conforms to", javaType="String")
    public static final String SPECIFIC_VERSION = "CamelDaprSpecificVersion";
    @Metadata(label="consumer", description="Gets the content type of the event data", javaType="String")
    public static final String DATA_CONTENT_TYPE = "CamelDaprDataContentType";
    @Metadata(label="consumer", description="Gets the raw binary data payload of the event, if present (for events where data_base64 is used instead of data)", javaType="byte[]")
    public static final String BINARY_DATA = "CamelDaprBinaryData";
    @Metadata(label="consumer", description="Gets the timestamp of when the event occurred", javaType="OffsetDateTime")
    public static final String TIME = "CamelDaprTime";
    @Metadata(label="consumer", description="Gets tracing info for following the event across services (includes trace ID and span ID)", javaType="String")
    public static final String TRACE_PARENT = "CamelDaprTraceParent";
    @Metadata(label="consumer", description="Gets additional vendor-specific trace context", javaType="String")
    public static final String TRACE_STATE = "CamelDaprTraceState";
    @Metadata(label="producer", description="The name of the Dapr binding to invoke", javaType="String")
    public static final String BINDING_NAME = "CamelDaprBindingName";
    @Metadata(label="producer", description="The operation to perform on the binding", javaType="String")
    public static final String BINDING_OPERATION = "CamelDaprBindingOperation";
    @Metadata(label="producer", description="List of keys for configuration operation", javaType="List<String>")
    public static final String CONFIG_KEYS = "CamelDaprConfigKeys";
    @Metadata(label="consumer", description="The id for configuration change subscription", javaType="String")
    public static final String SUBSCRIPTION_ID = "CamelDaprSubscriptionId";
    @Metadata(label="common", description="The raw configuration update response", javaType="Map<String, io.dapr.client.domain.ConfigurationItem")
    public static final String RAW_CONFIG_RESPONSE = "CamelDaprRawConfigResponse";
}

