/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dapr.operations;

import io.dapr.client.DaprClient;
import io.dapr.client.domain.GetBulkSecretRequest;
import io.dapr.client.domain.GetSecretRequest;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.dapr.DaprConfigurationOptionsProxy;
import org.apache.camel.component.dapr.operations.DaprOperationHandler;
import org.apache.camel.component.dapr.operations.DaprOperationResponse;
import org.apache.camel.util.ObjectHelper;

public class DaprSecretHandler
implements DaprOperationHandler {
    private final DaprConfigurationOptionsProxy configurationOptionsProxy;

    public DaprSecretHandler(DaprConfigurationOptionsProxy configurationOptionsProxy) {
        this.configurationOptionsProxy = configurationOptionsProxy;
    }

    @Override
    public DaprOperationResponse handle(Exchange exchange, DaprClient client) {
        Object response;
        String secretStore = this.configurationOptionsProxy.getSecretStore(exchange);
        String key = this.configurationOptionsProxy.getKey(exchange);
        Map<String, String> metadata = this.configurationOptionsProxy.getMetadata(exchange);
        if (ObjectHelper.isNotEmpty((String)key)) {
            GetSecretRequest secretRequest = new GetSecretRequest(secretStore, key);
            secretRequest.setMetadata(metadata);
            response = client.getSecret(secretRequest).block();
        } else {
            GetBulkSecretRequest secretRequest = new GetBulkSecretRequest(secretStore);
            secretRequest.setMetadata(metadata);
            response = client.getBulkSecret(secretRequest).block();
        }
        return DaprOperationResponse.create(response);
    }

    @Override
    public void validateConfiguration(Exchange exchange) {
        String secretStore = this.configurationOptionsProxy.getSecretStore(exchange);
        if (ObjectHelper.isEmpty((String)secretStore)) {
            throw new IllegalArgumentException("secretStore is mandatory to get secret");
        }
    }
}

