/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.cxf.CxfEndpointUtils;
import org.apache.camel.component.cxf.CxfOperationException;
import org.apache.camel.component.cxf.jaxrs.CxfRsBinding;
import org.apache.camel.component.cxf.jaxrs.CxfRsEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.LRUSoftCache;
import org.apache.cxf.Bus;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CxfRsProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(CxfRsProducer.class);
    private boolean throwException;
    private CxfRsEndpoint cxfRsEndpoint;
    private ClientFactoryBeanCache clientFactoryBeanCache;

    public CxfRsProducer(CxfRsEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.cxfRsEndpoint = endpoint;
        this.throwException = endpoint.isThrowExceptionOnFailure();
        this.clientFactoryBeanCache = new ClientFactoryBeanCache(endpoint.getMaxClientCacheSize());
    }

    protected void doStart() throws Exception {
        this.clientFactoryBeanCache.start();
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.clientFactoryBeanCache.stop();
    }

    public void process(Exchange exchange) throws Exception {
        Message inMessage = exchange.getIn();
        Boolean httpClientAPI = (Boolean)inMessage.getHeader("CamelCxfRsUsingHttpAPI", Boolean.class);
        if (httpClientAPI == null) {
            httpClientAPI = ((CxfRsEndpoint)this.getEndpoint()).isHttpClientAPI();
        }
        if (httpClientAPI.booleanValue()) {
            this.invokeHttpClient(exchange);
        } else {
            this.invokeProxyClient(exchange);
        }
    }

    protected void setupClientQueryAndHeaders(WebClient client, Exchange exchange) throws Exception {
        String queryString;
        Message inMessage = exchange.getIn();
        CxfRsEndpoint cxfRsEndpoint = (CxfRsEndpoint)this.getEndpoint();
        Map<String, String> maps = (Map<String, String>)inMessage.getHeader("CamelCxfRsQueryMap", Map.class);
        if (maps == null && (queryString = (String)inMessage.getHeader("CamelHttpQuery", String.class)) != null) {
            maps = this.getQueryParametersFromQueryString(queryString, IOHelper.getCharsetName((Exchange)exchange));
        }
        if (maps == null) {
            maps = cxfRsEndpoint.getParameters();
        }
        if (maps != null) {
            for (Map.Entry<String, String> entry : maps.entrySet()) {
                client.query(entry.getKey(), new Object[]{entry.getValue()});
            }
        }
        this.setupClientHeaders((Client)client, exchange);
    }

    protected void setupClientHeaders(Client client, Exchange exchange) throws Exception {
        Message inMessage = exchange.getIn();
        CxfRsEndpoint cxfRsEndpoint = (CxfRsEndpoint)this.getEndpoint();
        CxfRsBinding binding = cxfRsEndpoint.getBinding();
        client.headers(binding.bindCamelHeadersToRequestHeaders(inMessage.getHeaders(), exchange));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void invokeHttpClient(Exchange exchange) throws Exception {
        Integer respCode;
        void var13_17;
        Message inMessage = exchange.getIn();
        JAXRSClientFactoryBean cfb = this.clientFactoryBeanCache.get(CxfEndpointUtils.getEffectiveAddress(exchange, ((CxfRsEndpoint)this.getEndpoint()).getAddress()));
        Bus bus = ((CxfRsEndpoint)this.getEndpoint()).getBus();
        if (bus != null) {
            cfb.setBus(bus);
        }
        WebClient client = cfb.createWebClient();
        String httpMethod = (String)inMessage.getHeader("CamelHttpMethod", String.class);
        Class responseClass = (Class)inMessage.getHeader("CamelCxfRsResponseClass", Class.class);
        Type genericType = (Type)inMessage.getHeader("CamelCxfRsResponseGenericType", Type.class);
        String path = (String)inMessage.getHeader("CamelHttpPath", String.class);
        if (LOG.isTraceEnabled()) {
            LOG.trace("HTTP method = {}", (Object)httpMethod);
            LOG.trace("path = {}", (Object)path);
            LOG.trace("responseClass = {}", (Object)responseClass);
        }
        if (path != null) {
            client.path((Object)path);
        }
        CxfRsEndpoint cxfRsEndpoint = (CxfRsEndpoint)this.getEndpoint();
        CxfRsBinding binding = cxfRsEndpoint.getBinding();
        Object body = null;
        if (!("GET".equals(httpMethod) || "DELETE".equals(httpMethod) && cxfRsEndpoint.isIgnoreDeleteMethodMessageBody())) {
            body = binding.bindCamelMessageBodyToRequestBody(inMessage, exchange);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Request body = " + body);
            }
        }
        this.setupClientQueryAndHeaders(client, exchange);
        Object var13_13 = null;
        if (responseClass == null || Response.class.equals((Object)responseClass)) {
            Response response = client.invoke(httpMethod, body);
        } else if (Collection.class.isAssignableFrom(responseClass)) {
            if (!(genericType instanceof ParameterizedType)) throw new CamelExchangeException("Header CamelCxfRsResponseGenericType not found in message", exchange);
            Type[] actualTypeArguments = ((ParameterizedType)genericType).getActualTypeArguments();
            Collection collection = client.invokeAndGetCollection(httpMethod, body, (Class)actualTypeArguments[0]);
        } else {
            Object object = client.invoke(httpMethod, body, responseClass);
        }
        int statesCode = client.getResponse().getStatus();
        if (this.throwException && var13_17 instanceof Response && (respCode = Integer.valueOf(((Response)var13_17).getStatus())) > 207) {
            throw this.populateCxfRsProducerException(exchange, (Response)var13_17, respCode);
        }
        if (!exchange.getPattern().isOutCapable()) return;
        LOG.trace("Response body = {}", (Object)var13_17);
        exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
        exchange.getOut().setBody(binding.bindResponseToCamelBody(var13_17, exchange));
        exchange.getOut().getHeaders().putAll(binding.bindResponseHeadersToCamelHeaders(var13_17, exchange));
        exchange.getOut().setHeader("CamelHttpResponseCode", (Object)statesCode);
    }

    protected void invokeProxyClient(Exchange exchange) throws Exception {
        Integer respCode;
        Message inMessage = exchange.getIn();
        Object[] varValues = (Object[])inMessage.getHeader("CamelCxfRsVarValues", Object[].class);
        String methodName = (String)inMessage.getHeader("operationName", String.class);
        Client target = null;
        JAXRSClientFactoryBean cfb = this.clientFactoryBeanCache.get(CxfEndpointUtils.getEffectiveAddress(exchange, ((CxfRsEndpoint)this.getEndpoint()).getAddress()));
        Bus bus = ((CxfRsEndpoint)this.getEndpoint()).getBus();
        if (bus != null) {
            cfb.setBus(bus);
        }
        target = varValues == null ? cfb.create() : cfb.createWithValues(varValues);
        this.setupClientHeaders(target, exchange);
        JAXRSServiceFactoryBean sfb = cfb.getServiceFactory();
        sfb.getResourceClasses();
        Object[] parameters = null;
        if (inMessage.getBody() != null) {
            parameters = (Object[])inMessage.getBody(Object[].class);
        }
        Method method = this.findRightMethod(sfb.getResourceClasses(), methodName, this.getParameterTypes(parameters));
        Object response = method.invoke((Object)target, parameters);
        int statesCode = target.getResponse().getStatus();
        if (this.throwException && response instanceof Response && (respCode = Integer.valueOf(((Response)response).getStatus())) > 207) {
            throw this.populateCxfRsProducerException(exchange, (Response)response, respCode);
        }
        CxfRsEndpoint cxfRsEndpoint = (CxfRsEndpoint)this.getEndpoint();
        CxfRsBinding binding = cxfRsEndpoint.getBinding();
        if (exchange.getPattern().isOutCapable()) {
            LOG.trace("Response body = {}", response);
            exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
            exchange.getOut().setBody(binding.bindResponseToCamelBody(response, exchange));
            exchange.getOut().getHeaders().putAll(binding.bindResponseHeadersToCamelHeaders(response, exchange));
            exchange.getOut().setHeader("CamelHttpResponseCode", (Object)statesCode);
        }
    }

    private Map<String, String> getQueryParametersFromQueryString(String queryString, String charset) throws UnsupportedEncodingException {
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        for (String param : queryString.split("&")) {
            String[] pair = param.split("=", 2);
            if (pair.length != 2) {
                throw new IllegalArgumentException("Invalid parameter, expected to be a pair but was " + param);
            }
            String name = URLDecoder.decode(pair[0], charset);
            String value = URLDecoder.decode(pair[1], charset);
            answer.put(name, value);
        }
        return answer;
    }

    private Method findRightMethod(List<Class<?>> resourceClasses, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException {
        for (Class<?> clazz : resourceClasses) {
            try {
                Method[] m;
                block3: for (Method method : m = clazz.getMethods()) {
                    Class<?>[] params;
                    if (!method.getName().equals(methodName) || (params = method.getParameterTypes()).length != parameterTypes.length) continue;
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        if (!params[i].isAssignableFrom(parameterTypes[i])) continue block3;
                    }
                    return method;
                }
            }
            catch (SecurityException ex) {
            }
        }
        throw new NoSuchMethodException("Cannot find method with name: " + methodName + " having parameters assignable from: " + this.arrayToString(parameterTypes));
    }

    private Class<?>[] getParameterTypes(Object[] objects) {
        if (objects == null) {
            return new Class[0];
        }
        Class[] answer = new Class[objects.length];
        int i = 0;
        for (Object obj : objects) {
            answer[i] = obj.getClass();
            ++i;
        }
        return answer;
    }

    private String arrayToString(Object[] array) {
        StringBuilder buffer = new StringBuilder("[");
        for (Object obj : array) {
            if (buffer.length() > 2) {
                buffer.append(",");
            }
            buffer.append(obj.toString());
        }
        buffer.append("]");
        return buffer.toString();
    }

    protected CxfOperationException populateCxfRsProducerException(Exchange exchange, Response response, int responseCode) {
        CxfOperationException exception;
        String uri = exchange.getFromEndpoint().getEndpointUri();
        String statusText = Response.Status.fromStatusCode((int)responseCode).toString();
        Map<String, String> headers = this.parseResponseHeaders(response, exchange);
        String copy = (String)exchange.getContext().getTypeConverter().convertTo(String.class, response.getEntity());
        if (responseCode >= 300 && responseCode < 400) {
            if (response.getMetadata().getFirst((Object)"Location") != null) {
                String redirectLocation = response.getMetadata().getFirst((Object)"location").toString();
                exception = new CxfOperationException(uri, responseCode, statusText, redirectLocation, headers, copy);
            } else {
                exception = new CxfOperationException(uri, responseCode, statusText, null, headers, copy);
            }
        } else {
            exception = new CxfOperationException(uri, responseCode, statusText, null, headers, copy);
        }
        return exception;
    }

    protected Map<String, String> parseResponseHeaders(Object response, Exchange camelExchange) {
        HashMap<String, String> answer = new HashMap<String, String>();
        if (response instanceof Response) {
            for (Map.Entry entry : ((Response)response).getMetadata().entrySet()) {
                LOG.trace("Parse external header {}={}", entry.getKey(), entry.getValue());
                answer.put((String)entry.getKey(), ((List)entry.getValue()).get(0).toString());
            }
        }
        return answer;
    }

    private class ClientFactoryBeanCache {
        private LRUSoftCache<String, JAXRSClientFactoryBean> cache;

        public ClientFactoryBeanCache(int maxCacheSize) {
            this.cache = new LRUSoftCache(maxCacheSize);
        }

        public void start() throws Exception {
            this.cache.resetStatistics();
        }

        public void stop() throws Exception {
            this.cache.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JAXRSClientFactoryBean get(String address) throws Exception {
            JAXRSClientFactoryBean retVal = null;
            LRUSoftCache<String, JAXRSClientFactoryBean> lRUSoftCache = this.cache;
            synchronized (lRUSoftCache) {
                retVal = (JAXRSClientFactoryBean)this.cache.get((Object)address);
                if (retVal == null) {
                    retVal = ((CxfRsEndpoint)CxfRsProducer.this.getEndpoint()).createJAXRSClientFactoryBean(address);
                    this.cache.put((Object)address, (Object)retVal);
                    LOG.trace("Created client factory bean and add to cache for address '{}'", (Object)address);
                } else {
                    LOG.trace("Retrieved client factory bean from cache for address '{}'", (Object)address);
                }
            }
            return retVal;
        }
    }
}

