/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.feature;

import org.apache.camel.component.cxf.feature.AbstractDataFormatFeature;
import org.apache.camel.component.cxf.interceptors.RawMessageContentRedirectInterceptor;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.WSDLGetInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RAWDataFormatFeature
extends AbstractDataFormatFeature {
    private static final Logger LOG = LoggerFactory.getLogger(RAWDataFormatFeature.class);
    private static final String[] REMAINING_IN_PHASES = new String[]{"receive", "user-stream", "invoke", "post-invoke"};
    private static final String[] REMAINING_OUT_PHASES = new String[]{"prepare-send", "user-stream", "write", "send", "prepare-send-ending"};

    public void initialize(Client client, Bus bus) {
        this.removeInterceptorWhichIsOutThePhases(client.getInInterceptors(), REMAINING_IN_PHASES, this.getInInterceptorNames());
        this.removeInterceptorWhichIsOutThePhases(client.getEndpoint().getInInterceptors(), REMAINING_IN_PHASES, this.getInInterceptorNames());
        client.getEndpoint().getBinding().getInInterceptors().clear();
        this.getOutInterceptorNames().add(LoggingOutInterceptor.class.getName());
        this.removeInterceptorWhichIsOutThePhases(client.getOutInterceptors(), REMAINING_OUT_PHASES, this.getOutInterceptorNames());
        this.removeInterceptorWhichIsOutThePhases(client.getEndpoint().getOutInterceptors(), REMAINING_OUT_PHASES, this.getOutInterceptorNames());
        client.getEndpoint().getBinding().getOutInterceptors().clear();
        client.getEndpoint().getOutInterceptors().add(new RawMessageContentRedirectInterceptor());
    }

    public void initialize(Server server, Bus bus) {
        this.getInInterceptorNames().add(WSDLGetInterceptor.class.getName());
        this.removeInterceptorWhichIsOutThePhases(server.getEndpoint().getService().getInInterceptors(), REMAINING_IN_PHASES, this.getInInterceptorNames());
        this.removeInterceptorWhichIsOutThePhases(server.getEndpoint().getInInterceptors(), REMAINING_IN_PHASES, this.getInInterceptorNames());
        this.getOutInterceptorNames().add(LoggingOutInterceptor.class.getName());
        server.getEndpoint().getBinding().getInInterceptors().clear();
        this.removeInterceptorWhichIsOutThePhases(server.getEndpoint().getService().getOutInterceptors(), REMAINING_OUT_PHASES, this.getOutInterceptorNames());
        this.removeInterceptorWhichIsOutThePhases(server.getEndpoint().getOutInterceptors(), REMAINING_OUT_PHASES, this.getOutInterceptorNames());
        server.getEndpoint().getBinding().getOutInterceptors().clear();
        server.getEndpoint().getOutInterceptors().add(new RawMessageContentRedirectInterceptor());
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

