/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.csv;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.camel.dataformat.csv.CsvLineConverter;

public final class CsvLineConverters {
    private CsvLineConverters() {
    }

    public static CsvLineConverter<List<String>> getListConverter() {
        return ListLineConverter.SINGLETON;
    }

    public static CsvLineConverter<Map<String, String>> getMapLineConverter(String[] headers) {
        return new MapLineConverter(headers);
    }

    private static final class MapLineConverter
    implements CsvLineConverter<Map<String, String>> {
        private final String[] headers;

        private MapLineConverter(String[] headers) {
            this.headers = MapLineConverter.checkHeaders(headers);
        }

        @Override
        public Map<String, String> convertLine(String[] line) {
            if (line.length != this.headers.length) {
                throw new IllegalStateException("This line does not have the same number of items than the header");
            }
            HashMap<String, String> result = new HashMap<String, String>(line.length);
            for (int i = 0; i < line.length; ++i) {
                result.put(this.headers[i], line[i]);
            }
            return result;
        }

        private static String[] checkHeaders(String[] headers) {
            if (headers == null || headers.length == 0) {
                throw new IllegalArgumentException("Missing headers for the CSV parsing");
            }
            HashSet headerSet = new HashSet(headers.length);
            Collections.addAll(headerSet, headers);
            if (headerSet.size() != headers.length) {
                throw new IllegalArgumentException("There are duplicate headers");
            }
            return headers;
        }
    }

    private static final class ListLineConverter
    implements CsvLineConverter<List<String>> {
        public static final ListLineConverter SINGLETON = new ListLineConverter();

        private ListLineConverter() {
        }

        @Override
        public List<String> convertLine(String[] line) {
            return Arrays.asList(line);
        }
    }
}

