/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.couchbase;

import com.couchbase.client.core.retry.BestEffortRetryStrategy;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.kv.GetOptions;
import com.couchbase.client.java.kv.GetResult;
import com.couchbase.client.java.kv.MutationResult;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.RemoveOptions;
import com.couchbase.client.java.kv.ReplicateTo;
import com.couchbase.client.java.kv.UpsertOptions;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CouchbaseCollectionOperation {
    private static final Logger LOG = LoggerFactory.getLogger(CouchbaseCollectionOperation.class);

    private CouchbaseCollectionOperation() {
    }

    protected static Boolean setDocument(Collection collection, String id, int expiry, Object obj, PersistTo persistTo, ReplicateTo replicateTo, long writeQueryTimeout, long producerRetryPause) {
        UpsertOptions options = (UpsertOptions)((UpsertOptions)((UpsertOptions)UpsertOptions.upsertOptions().expiry(Duration.ofSeconds(expiry)).durability(persistTo, replicateTo)).timeout(Duration.ofMillis(writeQueryTimeout))).retryStrategy((RetryStrategy)BestEffortRetryStrategy.withExponentialBackoff((Duration)Duration.ofMillis(producerRetryPause), (Duration)Duration.ofMillis(producerRetryPause), (int)1));
        MutationResult result = collection.upsert(id, obj, options);
        if (LOG.isDebugEnabled()) {
            LOG.debug(result.toString());
        }
        return true;
    }

    protected static GetResult getDocument(Collection collection, String id, long queryTimeout, long retryPause) {
        GetOptions options = (GetOptions)((GetOptions)GetOptions.getOptions().timeout(Duration.ofMillis(queryTimeout))).retryStrategy((RetryStrategy)BestEffortRetryStrategy.withExponentialBackoff((Duration)Duration.ofMillis(retryPause), (Duration)Duration.ofMillis(retryPause), (int)1));
        return collection.get(id, options);
    }

    protected static MutationResult removeDocument(Collection collection, String id, long writeQueryTimeout, long producerRetryPause) {
        RemoveOptions options = (RemoveOptions)((RemoveOptions)RemoveOptions.removeOptions().timeout(Duration.ofMillis(writeQueryTimeout))).retryStrategy((RetryStrategy)BestEffortRetryStrategy.withExponentialBackoff((Duration)Duration.ofMillis(producerRetryPause), (Duration)Duration.ofMillis(producerRetryPause), (int)1));
        return collection.remove(id, options);
    }
}

