/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.couchbase;

import com.couchbase.client.CouchbaseClientIF;
import java.util.Map;
import java.util.concurrent.Future;
import net.spy.memcached.PersistTo;
import net.spy.memcached.ReplicateTo;
import net.spy.memcached.internal.OperationFuture;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.couchbase.CouchbaseEndpoint;
import org.apache.camel.component.couchbase.CouchbaseException;
import org.apache.camel.impl.DefaultProducer;

public class CouchbaseProducer
extends DefaultProducer {
    private CouchbaseEndpoint endpoint;
    private CouchbaseClientIF client;
    private long startId;
    private PersistTo persistTo;
    private ReplicateTo replicateTo;
    private int producerRetryAttempts;
    private int producerRetryPause;

    public CouchbaseProducer(CouchbaseEndpoint endpoint, CouchbaseClientIF client, int persistTo, int replicateTo) throws Exception {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.client = client;
        if (endpoint.isAutoStartIdForInserts()) {
            this.startId = endpoint.getStartingIdForInsertsFrom();
        }
        this.producerRetryAttempts = endpoint.getProducerRetryAttempts();
        this.producerRetryPause = endpoint.getProducerRetryPause();
        switch (persistTo) {
            case 0: {
                this.persistTo = PersistTo.ZERO;
                break;
            }
            case 1: {
                this.persistTo = PersistTo.MASTER;
                break;
            }
            case 2: {
                this.persistTo = PersistTo.TWO;
                break;
            }
            case 3: {
                this.persistTo = PersistTo.THREE;
                break;
            }
            case 4: {
                this.persistTo = PersistTo.FOUR;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported persistTo parameter. Supported values are 0 to 4. Currently provided: " + persistTo);
            }
        }
        switch (replicateTo) {
            case 0: {
                this.replicateTo = ReplicateTo.ZERO;
                break;
            }
            case 1: {
                this.replicateTo = ReplicateTo.ONE;
                break;
            }
            case 2: {
                this.replicateTo = ReplicateTo.TWO;
                break;
            }
            case 3: {
                this.replicateTo = ReplicateTo.THREE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported replicateTo parameter. Supported values are 0 to 3. Currently provided: " + replicateTo);
            }
        }
    }

    public void process(Exchange exchange) throws Exception {
        int ttl;
        Map headers = exchange.getIn().getHeaders();
        String id = headers.containsKey("CCB_ID") ? (String)exchange.getIn().getHeader("CCB_ID", String.class) : this.endpoint.getId();
        int n = ttl = headers.containsKey("CCB_TTL") ? Integer.parseInt((String)exchange.getIn().getHeader("CCB_TTL", String.class)) : 0;
        if (this.endpoint.isAutoStartIdForInserts()) {
            id = Long.toString(this.startId);
            ++this.startId;
        } else if (id == null) {
            throw new CouchbaseException("CCB_ID is not specified in message header or endpoint URL.", exchange);
        }
        if (this.endpoint.getOperation().equals("CCB_PUT")) {
            this.log.info("Type of operation: PUT");
            Object obj = exchange.getIn().getBody();
            exchange.getOut().setBody((Object)this.setDocument(id, ttl, obj, this.persistTo, this.replicateTo));
        } else if (this.endpoint.getOperation().equals("CCB_GET")) {
            this.log.info("Type of operation: GET");
            Object result = this.client.get(id);
            exchange.getOut().setBody(result);
        } else if (this.endpoint.getOperation().equals("CCB_DEL")) {
            this.log.info("Type of operation: DELETE");
            Future result = this.client.delete(id);
            exchange.getOut().setBody(result.get());
        }
        exchange.getIn().removeHeader("CCB_ID");
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.client != null) {
            this.client.shutdown();
        }
    }

    private Boolean setDocument(String id, int expiry, Object obj, PersistTo persistTo, ReplicateTo replicateTo) throws Exception {
        return this.setDocument(id, expiry, obj, this.producerRetryAttempts, persistTo, replicateTo);
    }

    private Boolean setDocument(String id, int expiry, Object obj, int retryAttempts, PersistTo persistTo, ReplicateTo replicateTo) throws Exception {
        OperationFuture result = this.client.set(id, expiry, obj, persistTo, replicateTo);
        try {
            if (!((Boolean)result.get()).booleanValue()) {
                throw new Exception("Unable to save Document. " + id);
            }
            return true;
        }
        catch (Exception e) {
            if (retryAttempts <= 0) {
                throw e;
            }
            this.log.info("Unable to save Document, retrying in " + this.producerRetryPause + "ms (" + retryAttempts + ")");
            Thread.sleep(this.producerRetryPause);
            return this.setDocument(id, expiry, obj, retryAttempts - 1, persistTo, replicateTo);
        }
    }
}

