/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul;

import com.orbitz.consul.Consul;
import java.util.Optional;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.consul.ConsulComponent;
import org.apache.camel.component.consul.ConsulConfiguration;
import org.apache.camel.component.consul.ConsulFactories;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.18.0", scheme="consul", title="Consul", syntax="consul:apiEndpoint", category={Category.CLOUD, Category.API})
public class ConsulEndpoint
extends DefaultEndpoint {
    @UriParam
    private final ConsulConfiguration configuration;
    @UriPath(description="The API endpoint")
    @Metadata(required=true)
    private final String apiEndpoint;
    private final Optional<ConsulFactories.ProducerFactory> producerFactory;
    private final Optional<ConsulFactories.ConsumerFactory> consumerFactory;
    private Consul consul;

    public ConsulEndpoint(String apiEndpoint, String uri, ConsulComponent component, ConsulConfiguration configuration, Optional<ConsulFactories.ProducerFactory> producerFactory, Optional<ConsulFactories.ConsumerFactory> consumerFactory) {
        super(uri, (Component)component);
        this.configuration = (ConsulConfiguration)ObjectHelper.notNull((Object)configuration, (String)"configuration");
        this.apiEndpoint = (String)ObjectHelper.notNull((Object)apiEndpoint, (String)"apiEndpoint");
        this.producerFactory = producerFactory;
        this.consumerFactory = consumerFactory;
    }

    public Producer createProducer() throws Exception {
        ConsulFactories.ProducerFactory factory = this.producerFactory.orElseThrow(() -> new IllegalArgumentException("No producer for " + this.apiEndpoint));
        return factory.create(this, this.configuration);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ConsulFactories.ConsumerFactory factory = this.consumerFactory.orElseThrow(() -> new IllegalArgumentException("No consumer for " + this.apiEndpoint));
        Consumer consumer = factory.create(this, this.configuration, processor);
        this.configureConsumer(consumer);
        return consumer;
    }

    public ConsulConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getApiEndpoint() {
        return this.apiEndpoint;
    }

    public synchronized Consul getConsul() throws Exception {
        if (this.consul == null && ObjectHelper.isEmpty((Object)this.getConfiguration().getConsulClient())) {
            this.consul = this.configuration.createConsulClient(this.getCamelContext());
        } else if (ObjectHelper.isNotEmpty((Object)this.getConfiguration().getConsulClient())) {
            this.consul = this.getConfiguration().getConsulClient();
        }
        return this.consul;
    }
}

