/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Route;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedConsumerMBean;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.api.management.mbean.ManagedSchedulePollConsumerMBean;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonObject;

@DevConsole(value="consumer")
public class ConsumerDevConsole
extends AbstractDevConsole {
    public ConsumerDevConsole() {
        super("camel", "consumer", "Consumers", "Display information about Camel consumers");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        ManagedCamelContext mcc = (ManagedCamelContext)this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        if (mcc != null) {
            for (Route route : this.getCamelContext().getRoutes()) {
                String id = route.getId();
                ManagedConsumerMBean mc = mcc.getManagedConsumer(id);
                if (mc == null) continue;
                Integer inflight = mc.getInflightExchanges();
                if (inflight == null) {
                    inflight = 0;
                }
                if (!sb.isEmpty()) {
                    sb.append("\n");
                }
                sb.append(String.format("\n    Id: %s", id));
                sb.append(String.format("\n    Uri: %s", mc.getEndpointUri()));
                sb.append(String.format("\n    State: %s", mc.getState()));
                sb.append(String.format("\n    Class: %s", mc.getServiceType()));
                sb.append(String.format("\n    Inflight: %d", inflight));
                if (mcc instanceof ManagedSchedulePollConsumerMBean) {
                    ManagedSchedulePollConsumerMBean mpc = (ManagedSchedulePollConsumerMBean)mcc;
                    sb.append(String.format("\n    Polling: %s", mpc.isPolling()));
                    sb.append(String.format("\n    First Poll Done: %s", mpc.isFirstPollDone()));
                    sb.append(String.format("\n    Scheduler Started: %s", mpc.isSchedulerStarted()));
                    sb.append(String.format("\n    Scheduler Class: %s", mpc.getSchedulerClassName()));
                    sb.append(String.format("\n    Repeat Count: %s", mpc.getRepeatCount()));
                    sb.append(String.format("\n    Fixed Delay: %s", mpc.isUseFixedDelay()));
                    sb.append(String.format("\n    Greedy: %s", mpc.isGreedy()));
                    sb.append(String.format("\n    Running Logging Level: %s", mpc.getRunningLoggingLevel()));
                    sb.append(String.format("\n    Send Empty Message When Idle: %s", mpc.isSendEmptyMessageWhenIdle()));
                    sb.append(String.format("\n    Counter(total: %d success: %d error: %d)", mpc.getCounter(), mpc.getSuccessCounter(), mpc.getErrorCounter()));
                    sb.append(String.format("\n    Delay(initial: %d delay: %d unit: %s)", mpc.getInitialDelay(), mpc.getDelay(), mpc.getTimeUnit()));
                    sb.append(String.format("\n    Backoff(counter: %d multiplier: %d errorThreshold: %d, idleThreshold: %d )", mpc.getBackoffCounter(), mpc.getBackoffMultiplier(), mpc.getBackoffErrorThreshold(), mpc.getBackoffIdleThreshold()));
                }
                if (!"TimerConsumer".equals(mc.getServiceType())) continue;
                try {
                    ObjectName on;
                    MBeanServer ms = ManagementFactory.getPlatformMBeanServer();
                    if (!ms.isRegistered(on = this.getCamelContext().getManagementStrategy().getManagementObjectNameStrategy().getObjectNameForConsumer(this.getCamelContext(), route.getConsumer()))) continue;
                    String timerName = (String)ms.getAttribute(on, "TimerName");
                    Long counter = (Long)ms.getAttribute(on, "Counter");
                    Boolean polling = (Boolean)ms.getAttribute(on, "Polling");
                    Boolean fixedRate = (Boolean)ms.getAttribute(on, "FixedRate");
                    Long delay = (Long)ms.getAttribute(on, "Delay");
                    Long period = (Long)ms.getAttribute(on, "Period");
                    Long repeatCount = (Long)ms.getAttribute(on, "RepeatCount");
                    String runLoggingLevel = (String)ms.getAttribute(on, "RunLoggingLevel");
                    sb.append(String.format("\n    Timer Name: %s", timerName));
                    sb.append(String.format("\n    Polling: %s", polling));
                    sb.append(String.format("\n    Fixed Rate: %s", fixedRate));
                    if (delay != null) {
                        sb.append(String.format("\n    Delay: %s", delay));
                    }
                    if (period != null) {
                        sb.append(String.format("\n    Period: %s", period));
                    }
                    if (repeatCount != null) {
                        sb.append(String.format("\n    Repeat Count: %s", repeatCount));
                    }
                    sb.append(String.format("\n    Running Logging Level: %s", runLoggingLevel));
                    sb.append(String.format("\n    Counter(total: %s)", counter));
                }
                catch (Exception exception) {}
            }
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        root.put((Object)"consumers", list);
        ManagedCamelContext mcc = (ManagedCamelContext)this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        if (mcc != null) {
            for (Route route : this.getCamelContext().getRoutes()) {
                String id = route.getId();
                ManagedRouteMBean mr = mcc.getManagedRoute(id);
                ManagedConsumerMBean mc = mcc.getManagedConsumer(id);
                if (mr == null || mc == null) continue;
                JsonObject jo = new JsonObject();
                Integer inflight = mc.getInflightExchanges();
                if (inflight == null) {
                    inflight = 0;
                }
                jo.put((Object)"id", (Object)id);
                jo.put((Object)"uri", (Object)mc.getEndpointUri());
                jo.put((Object)"state", (Object)mc.getState());
                jo.put((Object)"class", (Object)mc.getServiceType());
                jo.put((Object)"inflight", (Object)inflight);
                jo.put((Object)"scheduled", (Object)false);
                if (mcc instanceof ManagedSchedulePollConsumerMBean) {
                    ManagedSchedulePollConsumerMBean mpc = (ManagedSchedulePollConsumerMBean)mcc;
                    jo.put((Object)"scheduled", (Object)true);
                    jo.put((Object)"polling", (Object)mpc.isPolling());
                    jo.put((Object)"firstPollDone", (Object)mpc.isFirstPollDone());
                    jo.put((Object)"schedulerStarted", (Object)mpc.isSchedulerStarted());
                    jo.put((Object)"schedulerClass", (Object)mpc.getSchedulerClassName());
                    jo.put((Object)"repeatCount", (Object)mpc.getRepeatCount());
                    jo.put((Object)"fixedDelay", (Object)mpc.isUseFixedDelay());
                    jo.put((Object)"initialDelay", (Object)mpc.getInitialDelay());
                    jo.put((Object)"delay", (Object)mpc.getDelay());
                    jo.put((Object)"timeUnit", (Object)mpc.getTimeUnit());
                    jo.put((Object)"greedy", (Object)mpc.isGreedy());
                    jo.put((Object)"runningLoggingLevel", (Object)mpc.getRunningLoggingLevel());
                    jo.put((Object)"totalCounter", (Object)mpc.getCounter());
                    jo.put((Object)"errorCounter", (Object)mpc.getErrorCounter());
                    jo.put((Object)"successCounter", (Object)mpc.getSuccessCounter());
                    jo.put((Object)"backoffCounter", (Object)mpc.getBackoffCounter());
                    jo.put((Object)"backoffMultiplier", (Object)mpc.getBackoffMultiplier());
                    jo.put((Object)"backoffErrorThreshold", (Object)mpc.getBackoffErrorThreshold());
                    jo.put((Object)"backoffIdleThreshold", (Object)mpc.getBackoffIdleThreshold());
                }
                if ("TimerConsumer".equals(mc.getServiceType())) {
                    jo.put((Object)"scheduled", (Object)true);
                    try {
                        MBeanServer ms = ManagementFactory.getPlatformMBeanServer();
                        ObjectName on = this.getCamelContext().getManagementStrategy().getManagementObjectNameStrategy().getObjectNameForConsumer(this.getCamelContext(), route.getConsumer());
                        if (ms.isRegistered(on)) {
                            String timerName = (String)ms.getAttribute(on, "TimerName");
                            Long counter = (Long)ms.getAttribute(on, "Counter");
                            Boolean polling = (Boolean)ms.getAttribute(on, "Polling");
                            Boolean fixedRate = (Boolean)ms.getAttribute(on, "FixedRate");
                            Long delay = (Long)ms.getAttribute(on, "Delay");
                            Long period = (Long)ms.getAttribute(on, "Period");
                            Long repeatCount = (Long)ms.getAttribute(on, "RepeatCount");
                            String runLoggingLevel = (String)ms.getAttribute(on, "RunLoggingLevel");
                            jo.put((Object)"timerName", (Object)timerName);
                            jo.put((Object)"polling", (Object)polling);
                            jo.put((Object)"fixedRate", (Object)fixedRate);
                            if (delay != null) {
                                jo.put((Object)"delay", (Object)delay);
                            }
                            if (period != null) {
                                jo.put((Object)"period", (Object)period);
                            }
                            if (repeatCount != null) {
                                jo.put((Object)"repeatCount", (Object)repeatCount);
                            }
                            jo.put((Object)"runningLoggingLevel", (Object)runLoggingLevel);
                            jo.put((Object)"totalCounter", (Object)counter);
                        }
                    }
                    catch (Exception ms) {
                        // empty catch block
                    }
                }
                if (mr != null) {
                    Date last;
                    JsonObject stats = new JsonObject();
                    stats.put((Object)"idleSince", (Object)mr.getIdleSince());
                    stats.put((Object)"exchangesTotal", (Object)mr.getExchangesTotal());
                    stats.put((Object)"exchangesFailed", (Object)mr.getExchangesFailed());
                    stats.put((Object)"exchangesInflight", (Object)mr.getExchangesInflight());
                    stats.put((Object)"meanProcessingTime", (Object)mr.getMeanProcessingTime());
                    stats.put((Object)"maxProcessingTime", (Object)mr.getMaxProcessingTime());
                    stats.put((Object)"minProcessingTime", (Object)mr.getMinProcessingTime());
                    if (mr.getExchangesTotal() > 0L) {
                        stats.put((Object)"lastProcessingTime", (Object)mr.getLastProcessingTime());
                        stats.put((Object)"deltaProcessingTime", (Object)mr.getDeltaProcessingTime());
                    }
                    if ((last = mr.getLastExchangeCreatedTimestamp()) != null) {
                        stats.put((Object)"lastCreatedExchangeTimestamp", (Object)last.getTime());
                    }
                    if ((last = mr.getLastExchangeCompletedTimestamp()) != null) {
                        stats.put((Object)"lastCompletedExchangeTimestamp", (Object)last.getTime());
                    }
                    if ((last = mr.getLastExchangeFailureTimestamp()) != null) {
                        stats.put((Object)"lastFailedExchangeTimestamp", (Object)last.getTime());
                    }
                    jo.put((Object)"statistics", (Object)stats);
                }
                list.add(jo);
            }
        }
        return root;
    }
}

