/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.io.Closeable;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.Resource;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;

public final class ConsoleHelper {
    private ConsoleHelper() {
    }

    public static List<JsonObject> loadSourceAsJson(CamelContext camelContext, String location) {
        if (location == null) {
            return null;
        }
        Integer lineNumber = ConsoleHelper.extractSourceLocationLineNumber(location);
        try {
            location = LoggerHelper.stripSourceLocationLineNumber((String)location);
            Resource resource = PluginHelper.getResourceLoader((CamelContext)camelContext).resolveResource(location);
            if (resource != null) {
                return ConsoleHelper.loadSourceAsJson(resource.getReader(), lineNumber);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.EMPTY_LIST;
    }

    public static List<JsonObject> loadSourceAsJson(Reader reader, Integer lineNumber) {
        ArrayList<JsonObject> code = new ArrayList<JsonObject>();
        try {
            String t;
            LineNumberReader lnr = new LineNumberReader(reader);
            int i = 0;
            do {
                if ((t = lnr.readLine()) == null) continue;
                JsonObject c = new JsonObject();
                c.put((Object)"line", (Object)(++i));
                c.put((Object)"code", (Object)Jsoner.escape((String)t));
                if (lineNumber != null && lineNumber == i) {
                    c.put((Object)"match", (Object)true);
                }
                code.add(c);
            } while (t != null);
            IOHelper.close((Closeable)lnr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return code.isEmpty() ? null : code;
    }

    public static String loadSourceLine(CamelContext camelContext, String location, Integer lineNumber) {
        List<String> lines = ConsoleHelper.loadSourceLines(camelContext, location, lineNumber, lineNumber + 1);
        if (lines.size() == 1) {
            return lines.get(0);
        }
        return null;
    }

    public static List<String> loadSourceLines(CamelContext camelContext, String location, Integer start, Integer end) {
        if (location == null || start == null) {
            return Collections.emptyList();
        }
        ArrayList<String> answer = new ArrayList<String>();
        try {
            location = LoggerHelper.stripSourceLocationLineNumber((String)location);
            Resource resource = PluginHelper.getResourceLoader((CamelContext)camelContext).resolveResource(location);
            if (resource != null) {
                String t;
                LineNumberReader reader = new LineNumberReader(resource.getReader());
                int i = 0;
                do {
                    if ((t = reader.readLine()) == null || ++i < start || end != null && i >= end) continue;
                    answer.add(t);
                } while (t != null);
                IOHelper.close((Closeable)reader);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return answer;
    }

    public static Integer extractSourceLocationLineNumber(String location) {
        int pos;
        int cnt = StringHelper.countChar((String)location, (char)':');
        if (cnt > 0 && (pos = location.lastIndexOf(58)) < location.length() - 1) {
            String num = location.substring(pos + 1);
            try {
                return Integer.valueOf(num);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

