/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.ArrayList;
import java.util.Map;
import org.apache.camel.spi.EndpointServiceRegistry;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="service", displayName="Services", description="Services used for network communication with clients")
public class ServiceDevConsole
extends AbstractDevConsole {
    public ServiceDevConsole() {
        super("camel", "service", "Services", "Services used for network communication with clients");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        EndpointServiceRegistry esr = this.getCamelContext().getCamelContextExtension().getEndpointServiceRegistry();
        for (EndpointServiceRegistry.EndpointService es : esr.listAllEndpointServices()) {
            if (!sb.isEmpty()) {
                sb.append("\n");
            }
            sb.append(String.format("\n    Component: %s", es.getComponent()));
            sb.append(String.format("\n    Direction: %s", es.getDirection()));
            sb.append(String.format("\n    Hosted: %b", es.isHostedService()));
            sb.append(String.format("\n    Protocol: %s", es.getServiceProtocol()));
            sb.append(String.format("\n    Service: %s", es.getServiceUrl()));
            sb.append(String.format("\n    Endpoint: %s", URISupport.sanitizeUri((String)es.getServiceUrl())));
            if (es.getRouteId() != null) {
                sb.append(String.format("\n    Route Id: %s", es.getRouteId()));
            }
            sb.append(String.format("\n    Total Messages: %d", es.getHits()));
        }
        sb.append("\n");
        return sb.toString();
    }

    protected Map<String, Object> doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        root.put((Object)"services", list);
        EndpointServiceRegistry esr = this.getCamelContext().getCamelContextExtension().getEndpointServiceRegistry();
        for (EndpointServiceRegistry.EndpointService es : esr.listAllEndpointServices()) {
            JsonObject jo = new JsonObject();
            jo.put((Object)"component", (Object)es.getComponent());
            jo.put((Object)"direction", (Object)es.getDirection());
            jo.put((Object)"hosted", (Object)es.isHostedService());
            jo.put((Object)"protocol", (Object)es.getServiceProtocol());
            jo.put((Object)"serviceUrl", (Object)es.getServiceUrl());
            jo.put((Object)"endpointUri", (Object)es.getEndpointUri());
            if (es.getRouteId() != null) {
                jo.put((Object)"routeId", (Object)es.getRouteId());
            }
            jo.put((Object)"hits", (Object)es.getHits());
            Map map = es.getServiceMetadata();
            if (map != null) {
                jo.put((Object)"metadata", (Object)map);
            }
            list.add(jo);
        }
        return root;
    }
}

