/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.connector.util;

import java.util.List;
import java.util.Map;

public final class StringHelper {
    private StringHelper() {
    }

    public static String camelCaseToDash(String value) {
        StringBuilder sb = new StringBuilder(value.length());
        boolean dash = false;
        for (char c : value.toCharArray()) {
            if (sb.length() > 0 & Character.isUpperCase(c)) {
                dash = true;
            }
            if (dash) {
                sb.append('-');
                sb.append(Character.toLowerCase(c));
            } else if (sb.length() == 0) {
                sb.append(Character.toLowerCase(c));
            } else {
                sb.append(c);
            }
            dash = false;
        }
        return sb.toString();
    }

    public static String nullSafe(String text) {
        return text != null ? text : "";
    }

    public static boolean isNullOrEmpty(String text) {
        return text == null || text.length() == 0 || "null".equals(text);
    }

    public static String safeNull(String text) {
        if (StringHelper.isNullOrEmpty(text)) {
            return "";
        }
        return text;
    }

    public static String getOrElse(String text, String defaultValue) {
        return text != null ? text : defaultValue;
    }

    public static String after(String text, String after) {
        if (!text.contains(after)) {
            return null;
        }
        return text.substring(text.indexOf(after) + after.length());
    }

    public static String canonicalClassName(String className) {
        int pos = className.indexOf(60);
        if (pos != -1) {
            return className.substring(0, pos);
        }
        return className;
    }

    public static String doubleQuote(String text) {
        return StringHelper.quote(text, "\"");
    }

    public static String singleQuote(String text) {
        return StringHelper.quote(text, "'");
    }

    public static String quote(String text, String quote) {
        return quote + text + quote;
    }

    public static String between(String text, String start, String end) {
        int pos2;
        int pos = text.indexOf(start);
        if (pos > 0) {
            text = text.substring(pos + 1);
        }
        if ((pos2 = text.lastIndexOf(end)) > 0) {
            text = text.substring(0, pos2);
        }
        return text;
    }

    public static String asTitle(String name) {
        StringBuilder sb = new StringBuilder();
        for (char c : name.toCharArray()) {
            boolean first;
            boolean upper = Character.isUpperCase(c);
            boolean bl = first = sb.length() == 0;
            if (first) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            if (upper) {
                sb.append(' ');
                sb.append(c);
                continue;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString().trim();
    }

    public static String getSafeValue(String key, List<Map<String, String>> rows) {
        for (Map<String, String> row : rows) {
            String value = row.get(key);
            if (value == null) continue;
            return value;
        }
        return "";
    }

    public static String getSafeValue(String key, Map<String, String> rows) {
        String value = rows.get(key);
        if (value != null) {
            return value;
        }
        return "";
    }

    public static String getShortJavaType(String javaType) {
        if (javaType.startsWith("java.util.Map")) {
            return "Map";
        }
        if (javaType.startsWith("java.util.Set")) {
            return "Set";
        }
        if (javaType.startsWith("java.util.List")) {
            return "List";
        }
        int pos = javaType.lastIndexOf(".");
        if (pos != -1) {
            return javaType.substring(pos + 1);
        }
        return javaType;
    }
}

