/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.connector.util;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.Set;
import org.apache.camel.json.simple.Jsoner;
import org.apache.camel.maven.connector.util.CollectionStringBuffer;
import org.apache.camel.maven.connector.util.StringHelper;

public final class JSonSchemaHelper {
    private static final String VALID_CHARS = ".-='/\\!&():;";

    private JSonSchemaHelper() {
    }

    public static String toJson(String name, String displayName, String kind, Boolean required, String type, String defaultValue, String description, Boolean deprecated, Boolean secret, String group, String label, boolean enumType, Set<String> enums, boolean oneOfType, Set<String> oneOffTypes, boolean asPredicate, String optionalPrefix, String prefix, boolean multiValue) {
        boolean predicate;
        String text;
        String typeName = JSonSchemaHelper.getType(type, enumType);
        StringBuilder sb = new StringBuilder();
        sb.append(StringHelper.doubleQuote(name));
        sb.append(": { \"kind\": ");
        sb.append(StringHelper.doubleQuote(kind));
        if (StringHelper.isNullOrEmpty(displayName)) {
            displayName = StringHelper.asTitle(name);
        }
        sb.append(", \"displayName\": ");
        sb.append(StringHelper.doubleQuote(displayName));
        if (!StringHelper.isNullOrEmpty(group)) {
            sb.append(", \"group\": ");
            sb.append(StringHelper.doubleQuote(group));
        }
        if (!StringHelper.isNullOrEmpty(label)) {
            sb.append(", \"label\": ");
            sb.append(StringHelper.doubleQuote(label));
        }
        if (required != null) {
            sb.append(", \"required\": ");
            sb.append(required.toString());
        }
        sb.append(", \"type\": ");
        if ("enum".equals(typeName)) {
            String actualType = JSonSchemaHelper.getType(type, false);
            sb.append(StringHelper.doubleQuote(actualType));
            sb.append(", \"javaType\": \"" + type + "\"");
            CollectionStringBuffer enumValues = new CollectionStringBuffer();
            for (String value : enums) {
                enumValues.append(StringHelper.doubleQuote(value.toString()));
            }
            sb.append(", \"enum\": [ ");
            sb.append(enumValues.toString());
            sb.append(" ]");
        } else if (oneOfType) {
            sb.append(StringHelper.doubleQuote(typeName));
            sb.append(", \"javaType\": \"" + type + "\"");
            CollectionStringBuffer oneOfValues = new CollectionStringBuffer();
            for (Object e : oneOffTypes) {
                oneOfValues.append(StringHelper.doubleQuote(e.toString()));
            }
            sb.append(", \"oneOf\": [ ");
            sb.append(oneOfValues.toString());
            sb.append(" ]");
        } else if ("array".equals(typeName)) {
            sb.append(StringHelper.doubleQuote("array"));
            sb.append(", \"javaType\": \"" + type + "\"");
        } else {
            sb.append(StringHelper.doubleQuote(typeName));
            sb.append(", \"javaType\": \"" + type + "\"");
        }
        if (!StringHelper.isNullOrEmpty(optionalPrefix)) {
            sb.append(", \"optionalPrefix\": ");
            text = JSonSchemaHelper.safeDefaultValue(optionalPrefix);
            sb.append(StringHelper.doubleQuote(text));
        }
        if (!StringHelper.isNullOrEmpty(prefix)) {
            sb.append(", \"prefix\": ");
            text = JSonSchemaHelper.safeDefaultValue(prefix);
            sb.append(StringHelper.doubleQuote(text));
        }
        if (multiValue) {
            sb.append(", \"multiValue\": true");
        }
        if (deprecated != null) {
            sb.append(", \"deprecated\": ");
            sb.append(deprecated.toString());
        }
        if (secret != null) {
            sb.append(", \"secret\": ");
            sb.append(secret.toString());
        }
        if (!StringHelper.isNullOrEmpty(defaultValue)) {
            sb.append(", \"defaultValue\": ");
            text = JSonSchemaHelper.safeDefaultValue(defaultValue);
            if ("boolean".equals(typeName) || "integer".equals(typeName) || "number".equals(typeName)) {
                sb.append(text);
            } else {
                sb.append(StringHelper.doubleQuote(text));
            }
        }
        boolean bl = predicate = "expression".equals(kind) || asPredicate;
        if (predicate) {
            sb.append(", \"asPredicate\": ");
            if (asPredicate) {
                sb.append("true");
            } else {
                sb.append("false");
            }
        }
        if (!StringHelper.isNullOrEmpty(description)) {
            sb.append(", \"description\": ");
            String text2 = JSonSchemaHelper.sanitizeDescription(description, false);
            sb.append(StringHelper.doubleQuote(text2));
        }
        sb.append(" }");
        return sb.toString();
    }

    public static String prettyPrint(String json) {
        return Jsoner.prettyPrint((String)json, (int)2);
    }

    public static String getType(String type, boolean enumType) {
        if (enumType) {
            return "enum";
        }
        if (type == null) {
            return "object";
        }
        if (type.equals(URI.class.getName()) || type.equals(URL.class.getName())) {
            return "string";
        }
        if (type.equals(File.class.getName())) {
            return "string";
        }
        if (type.equals(Date.class.getName())) {
            return "string";
        }
        if (type.startsWith("java.lang.Class")) {
            return "string";
        }
        if (type.startsWith("java.util.List") || type.startsWith("java.util.Collection")) {
            return "array";
        }
        String primitive = JSonSchemaHelper.getPrimitiveType(type);
        if (primitive != null) {
            return primitive;
        }
        return "object";
    }

    public static String getPrimitiveType(String name) {
        if ("java.lang.byte[]".equals(name) || "byte[]".equals(name)) {
            return "string";
        }
        if ("java.lang.Byte[]".equals(name) || "Byte[]".equals(name)) {
            return "array";
        }
        if ("java.lang.Object[]".equals(name) || "Object[]".equals(name)) {
            return "array";
        }
        if ("java.lang.String[]".equals(name) || "String[]".equals(name)) {
            return "array";
        }
        if ("java.lang.Character".equals(name) || "Character".equals(name) || "char".equals(name)) {
            return "string";
        }
        if ("java.lang.String".equals(name) || "String".equals(name)) {
            return "string";
        }
        if ("java.lang.Boolean".equals(name) || "Boolean".equals(name) || "boolean".equals(name)) {
            return "boolean";
        }
        if ("java.lang.Integer".equals(name) || "Integer".equals(name) || "int".equals(name)) {
            return "integer";
        }
        if ("java.lang.Long".equals(name) || "Long".equals(name) || "long".equals(name)) {
            return "integer";
        }
        if ("java.lang.Short".equals(name) || "Short".equals(name) || "short".equals(name)) {
            return "integer";
        }
        if ("java.lang.Byte".equals(name) || "Byte".equals(name) || "byte".equals(name)) {
            return "integer";
        }
        if ("java.lang.Float".equals(name) || "Float".equals(name) || "float".equals(name)) {
            return "number";
        }
        if ("java.lang.Double".equals(name) || "Double".equals(name) || "double".equals(name)) {
            return "number";
        }
        return null;
    }

    public static String sanitizeDescription(String javadoc, boolean summary) {
        if (StringHelper.isNullOrEmpty(javadoc)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String[] lines = javadoc.split("\n");
        boolean first = true;
        for (String line : lines) {
            boolean haveText;
            if ((line = line.trim()).startsWith("@param") || line.startsWith("@return") || line.startsWith("@deprecated")) break;
            if (line.startsWith("@")) continue;
            line = line.replaceAll("<.*?>", "");
            line = line.replaceAll("\\{\\@\\w+\\s([\\w.]+)\\}", "$1");
            if (!first) {
                sb.append(' ');
            }
            StringBuilder cb = new StringBuilder();
            for (char c : line.toCharArray()) {
                if (Character.isJavaIdentifierPart(c) || VALID_CHARS.indexOf(c) != -1) {
                    cb.append(c);
                    continue;
                }
                if (!Character.isWhitespace(c)) continue;
                cb.append(' ');
            }
            String s = cb.toString().trim();
            sb.append(s);
            boolean empty = StringHelper.isNullOrEmpty(s);
            boolean endWithDot = s.endsWith(".");
            boolean bl = haveText = sb.length() > 0;
            if (haveText && summary && (empty || endWithDot)) break;
            first = false;
        }
        String s = sb.toString();
        s = s.replaceAll("\\s+", " ");
        return s.trim();
    }

    private static String safeDefaultValue(String value) {
        if ("\"".equals(value)) {
            return "\\\"";
        }
        if ("\\".equals(value)) {
            return "\\\\";
        }
        return value;
    }
}

