/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.ibm.watson.discovery.WatsonDiscoveryComponent;
import org.apache.camel.component.ibm.watson.discovery.WatsonDiscoveryConfiguration;
import org.apache.camel.component.ibm.watson.discovery.WatsonDiscoveryOperations;

public interface IbmWatsonDiscoveryComponentBuilderFactory {
    public static IbmWatsonDiscoveryComponentBuilder ibmWatsonDiscovery() {
        return new IbmWatsonDiscoveryComponentBuilderImpl();
    }

    public static class IbmWatsonDiscoveryComponentBuilderImpl
    extends AbstractComponentBuilder<WatsonDiscoveryComponent>
    implements IbmWatsonDiscoveryComponentBuilder {
        @Override
        protected WatsonDiscoveryComponent buildConcreteComponent() {
            return new WatsonDiscoveryComponent();
        }

        private WatsonDiscoveryConfiguration getOrCreateConfiguration(WatsonDiscoveryComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new WatsonDiscoveryConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "projectId": {
                    this.getOrCreateConfiguration((WatsonDiscoveryComponent)component).setProjectId((String)value);
                    return true;
                }
                case "serviceUrl": {
                    this.getOrCreateConfiguration((WatsonDiscoveryComponent)component).setServiceUrl((String)value);
                    return true;
                }
                case "version": {
                    this.getOrCreateConfiguration((WatsonDiscoveryComponent)component).setVersion((String)value);
                    return true;
                }
                case "collectionId": {
                    this.getOrCreateConfiguration((WatsonDiscoveryComponent)component).setCollectionId((String)value);
                    return true;
                }
                case "configuration": {
                    ((WatsonDiscoveryComponent)component).setConfiguration((WatsonDiscoveryConfiguration)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((WatsonDiscoveryComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((WatsonDiscoveryComponent)component).setOperation((WatsonDiscoveryOperations)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((WatsonDiscoveryComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "apiKey": {
                    this.getOrCreateConfiguration((WatsonDiscoveryComponent)component).setApiKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface IbmWatsonDiscoveryComponentBuilder
    extends ComponentBuilder<WatsonDiscoveryComponent> {
        default public IbmWatsonDiscoveryComponentBuilder projectId(String projectId) {
            this.doSetProperty("projectId", projectId);
            return this;
        }

        default public IbmWatsonDiscoveryComponentBuilder serviceUrl(String serviceUrl) {
            this.doSetProperty("serviceUrl", serviceUrl);
            return this;
        }

        default public IbmWatsonDiscoveryComponentBuilder version(String version) {
            this.doSetProperty("version", version);
            return this;
        }

        default public IbmWatsonDiscoveryComponentBuilder collectionId(String collectionId) {
            this.doSetProperty("collectionId", collectionId);
            return this;
        }

        default public IbmWatsonDiscoveryComponentBuilder configuration(WatsonDiscoveryConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public IbmWatsonDiscoveryComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public IbmWatsonDiscoveryComponentBuilder operation(WatsonDiscoveryOperations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public IbmWatsonDiscoveryComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public IbmWatsonDiscoveryComponentBuilder apiKey(String apiKey) {
            this.doSetProperty("apiKey", apiKey);
            return this;
        }
    }
}

