/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import io.netty.handler.ssl.SslContext;
import java.time.Duration;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.etcd3.Etcd3Component;
import org.apache.camel.component.etcd3.Etcd3Configuration;

public interface Etcd3ComponentBuilderFactory {
    public static Etcd3ComponentBuilder etcd3() {
        return new Etcd3ComponentBuilderImpl();
    }

    public static class Etcd3ComponentBuilderImpl
    extends AbstractComponentBuilder<Etcd3Component>
    implements Etcd3ComponentBuilder {
        @Override
        protected Etcd3Component buildConcreteComponent() {
            return new Etcd3Component();
        }

        private Etcd3Configuration getOrCreateConfiguration(Etcd3Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new Etcd3Configuration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((Etcd3Component)component).setConfiguration((Etcd3Configuration)value);
                    return true;
                }
                case "endpoints": {
                    this.getOrCreateConfiguration((Etcd3Component)component).setEndpoints((String)value);
                    return true;
                }
                case "keyCharset": {
                    this.getOrCreateConfiguration((Etcd3Component)component).setKeyCharset((String)value);
                    return true;
                }
                case "namespace": {
                    this.getOrCreateConfiguration((Etcd3Component)component).setNamespace((String)value);
                    return true;
                }
                case "prefix": {
                    this.getOrCreateConfiguration((Etcd3Component)component).setPrefix(((Boolean)value).booleanValue());
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((Etcd3Component)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "fromIndex": {
                    this.getOrCreateConfiguration((Etcd3Component)component).setFromIndex(((Long)value).longValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((Etcd3Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "valueCharset": {
                    this.getOrCreateConfiguration((Etcd3Component)component).setValueCharset((String)value);
                    return true;
                }
                case "authHeaders": {
                    this.getOrCreateConfiguration((Etcd3Component)component).setAuthHeaders((Map)value);
                    return true;
                }
                case "authority": {
                    this.getOrCreateConfiguration((Etcd3Component)component).setAuthority((String)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((Etcd3Component)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "connectionTimeout": {
                    this.getOrCreateConfiguration((Etcd3Component)component).setConnectionTimeout((Duration)value);
                    return true;
                }
                case "headers": {
                    this.getOrCreateConfiguration((Etcd3Component)component).setHeaders((Map)value);
                    return true;
                }
                case "keepAliveTime": {
                    this.getOrCreateConfiguration((Etcd3Component)component).setKeepAliveTime((Duration)value);
                    return true;
                }
                case "keepAliveTimeout": {
                    this.getOrCreateConfiguration((Etcd3Component)component).setKeepAliveTimeout((Duration)value);
                    return true;
                }
                case "loadBalancerPolicy": {
                    this.getOrCreateConfiguration((Etcd3Component)component).setLoadBalancerPolicy((String)value);
                    return true;
                }
                case "maxInboundMessageSize": {
                    this.getOrCreateConfiguration((Etcd3Component)component).setMaxInboundMessageSize((Integer)value);
                    return true;
                }
                case "retryDelay": {
                    this.getOrCreateConfiguration((Etcd3Component)component).setRetryDelay(((Long)value).longValue());
                    return true;
                }
                case "retryMaxDelay": {
                    this.getOrCreateConfiguration((Etcd3Component)component).setRetryMaxDelay(((Long)value).longValue());
                    return true;
                }
                case "retryMaxDuration": {
                    this.getOrCreateConfiguration((Etcd3Component)component).setRetryMaxDuration((Duration)value);
                    return true;
                }
                case "servicePath": {
                    this.getOrCreateConfiguration((Etcd3Component)component).setServicePath((String)value);
                    return true;
                }
                case "password": {
                    this.getOrCreateConfiguration((Etcd3Component)component).setPassword((String)value);
                    return true;
                }
                case "sslContext": {
                    this.getOrCreateConfiguration((Etcd3Component)component).setSslContext((SslContext)value);
                    return true;
                }
                case "userName": {
                    this.getOrCreateConfiguration((Etcd3Component)component).setUserName((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Etcd3ComponentBuilder
    extends ComponentBuilder<Etcd3Component> {
        default public Etcd3ComponentBuilder configuration(Etcd3Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Etcd3ComponentBuilder endpoints(String endpoints) {
            this.doSetProperty("endpoints", endpoints);
            return this;
        }

        default public Etcd3ComponentBuilder keyCharset(String keyCharset) {
            this.doSetProperty("keyCharset", keyCharset);
            return this;
        }

        default public Etcd3ComponentBuilder namespace(String namespace) {
            this.doSetProperty("namespace", namespace);
            return this;
        }

        default public Etcd3ComponentBuilder prefix(boolean prefix) {
            this.doSetProperty("prefix", prefix);
            return this;
        }

        default public Etcd3ComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public Etcd3ComponentBuilder fromIndex(long fromIndex) {
            this.doSetProperty("fromIndex", fromIndex);
            return this;
        }

        default public Etcd3ComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Etcd3ComponentBuilder valueCharset(String valueCharset) {
            this.doSetProperty("valueCharset", valueCharset);
            return this;
        }

        default public Etcd3ComponentBuilder authHeaders(Map<String, String> authHeaders) {
            this.doSetProperty("authHeaders", authHeaders);
            return this;
        }

        default public Etcd3ComponentBuilder authority(String authority) {
            this.doSetProperty("authority", authority);
            return this;
        }

        default public Etcd3ComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public Etcd3ComponentBuilder connectionTimeout(Duration connectionTimeout) {
            this.doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }

        default public Etcd3ComponentBuilder headers(Map<String, String> headers) {
            this.doSetProperty("headers", headers);
            return this;
        }

        default public Etcd3ComponentBuilder keepAliveTime(Duration keepAliveTime) {
            this.doSetProperty("keepAliveTime", keepAliveTime);
            return this;
        }

        default public Etcd3ComponentBuilder keepAliveTimeout(Duration keepAliveTimeout) {
            this.doSetProperty("keepAliveTimeout", keepAliveTimeout);
            return this;
        }

        default public Etcd3ComponentBuilder loadBalancerPolicy(String loadBalancerPolicy) {
            this.doSetProperty("loadBalancerPolicy", loadBalancerPolicy);
            return this;
        }

        default public Etcd3ComponentBuilder maxInboundMessageSize(Integer maxInboundMessageSize) {
            this.doSetProperty("maxInboundMessageSize", maxInboundMessageSize);
            return this;
        }

        default public Etcd3ComponentBuilder retryDelay(long retryDelay) {
            this.doSetProperty("retryDelay", retryDelay);
            return this;
        }

        default public Etcd3ComponentBuilder retryMaxDelay(long retryMaxDelay) {
            this.doSetProperty("retryMaxDelay", retryMaxDelay);
            return this;
        }

        default public Etcd3ComponentBuilder retryMaxDuration(Duration retryMaxDuration) {
            this.doSetProperty("retryMaxDuration", retryMaxDuration);
            return this;
        }

        default public Etcd3ComponentBuilder servicePath(String servicePath) {
            this.doSetProperty("servicePath", servicePath);
            return this;
        }

        default public Etcd3ComponentBuilder password(String password) {
            this.doSetProperty("password", password);
            return this;
        }

        default public Etcd3ComponentBuilder sslContext(SslContext sslContext) {
            this.doSetProperty("sslContext", sslContext);
            return this;
        }

        default public Etcd3ComponentBuilder userName(String userName) {
            this.doSetProperty("userName", userName);
            return this;
        }
    }
}

