/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.commands.jolokia;

import org.jolokia.client.BasicAuthenticator;
import org.jolokia.client.J4pAuthenticator;
import org.jolokia.client.J4pClient;
import org.jolokia.client.J4pClientBuilder;
import org.jolokia.client.J4pClientBuilderFactory;

public final class JolokiaClientFactory {
    private JolokiaClientFactory() {
    }

    public static J4pClient createJolokiaClient(String jolokiaUrl, String username, String password) {
        J4pClientBuilder builder = J4pClientBuilderFactory.url((String)jolokiaUrl);
        boolean auth = false;
        if (JolokiaClientFactory.isNotEmpty(username)) {
            builder = builder.user(username);
            auth = true;
        }
        if (JolokiaClientFactory.isNotEmpty(password)) {
            builder = builder.password(password);
            auth = true;
        }
        if (auth) {
            builder = builder.authenticator((J4pAuthenticator)new BasicAuthenticator(true));
        }
        return builder.build();
    }

    private static boolean isNotEmpty(String text) {
        return text != null && !text.isEmpty();
    }
}

