/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.cloud;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.apache.camel.Exchange;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.cloud.ServiceFilter;
import org.apache.camel.impl.cloud.DefaultServiceDefinition;

public class BlacklistServiceFilter
implements ServiceFilter {
    private List<ServiceDefinition> services;

    public BlacklistServiceFilter() {
        this.services = new ArrayList<ServiceDefinition>();
    }

    public BlacklistServiceFilter(List<ServiceDefinition> blacklist) {
        this.services = new ArrayList<ServiceDefinition>(blacklist);
    }

    public void setServers(List<String> servers) {
        this.services.clear();
        servers.forEach(this::addServer);
    }

    public void setServers(String servers) {
        this.services.clear();
        this.addServer(servers);
    }

    public void addServer(ServiceDefinition server) {
        this.services.add(server);
    }

    public void addServer(String serverString) {
        DefaultServiceDefinition.parse(serverString).forEach(this::addServer);
    }

    public void removeServer(Predicate<ServiceDefinition> condition) {
        this.services.removeIf(condition);
    }

    public List<ServiceDefinition> apply(Exchange exchange, List<ServiceDefinition> services) {
        return services.stream().filter(s -> this.services.stream().noneMatch(b -> b.matches(s))).toList();
    }

    List<ServiceDefinition> getBlacklistedServices() {
        return Collections.unmodifiableList(this.services);
    }

    public static BlacklistServiceFilter forServices(Collection<ServiceDefinition> definitions) {
        BlacklistServiceFilter filter = new BlacklistServiceFilter();
        for (ServiceDefinition definition : definitions) {
            filter.addServer(definition);
        }
        return filter;
    }

    public static BlacklistServiceFilter forServices(ServiceDefinition ... definitions) {
        BlacklistServiceFilter filter = new BlacklistServiceFilter();
        for (ServiceDefinition definition : definitions) {
            filter.addServer(definition);
        }
        return filter;
    }
}

