/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.cloud;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.cloud.ServiceLoadBalancer;
import org.apache.camel.spi.Language;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServiceCallProcessor
extends AsyncProcessorSupport {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServiceCallProcessor.class);
    private final ExchangePattern exchangePattern;
    private final String name;
    private final String scheme;
    private final String uri;
    private final String contextPath;
    private final CamelContext camelContext;
    private final ServiceLoadBalancer loadBalancer;
    private final Expression expression;
    private AsyncProcessor processor;

    public DefaultServiceCallProcessor(CamelContext camelContext, String name, String scheme, String uri, ExchangePattern exchangePattern, ServiceLoadBalancer loadBalancer, Expression expression) {
        String serviceName;
        this.uri = uri;
        this.exchangePattern = exchangePattern;
        this.camelContext = camelContext;
        this.loadBalancer = loadBalancer;
        if (name.contains("/")) {
            serviceName = StringHelper.before((String)name, (String)"/");
            this.contextPath = StringHelper.after((String)name, (String)"/");
        } else if (name.contains("?")) {
            serviceName = StringHelper.before((String)name, (String)"?");
            this.contextPath = StringHelper.after((String)name, (String)"?");
        } else {
            serviceName = name;
            this.contextPath = null;
        }
        if (serviceName.contains(":")) {
            this.scheme = StringHelper.before((String)serviceName, (String)":");
            this.name = StringHelper.after((String)serviceName, (String)":");
        } else {
            this.scheme = scheme;
            this.name = serviceName;
        }
        this.expression = expression;
    }

    public ExchangePattern getExchangePattern() {
        return this.exchangePattern;
    }

    public String getName() {
        return this.name;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getUri() {
        return this.uri;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public ServiceLoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public Expression getExpression() {
        return this.expression;
    }

    protected void doInit() throws Exception {
        StringHelper.notEmpty((String)this.name, (String)"name", (Object)"service name");
        ObjectHelper.notNull((Object)this.camelContext, (String)"camel context");
        ObjectHelper.notNull((Object)this.expression, (String)"expression");
        ObjectHelper.notNull((Object)this.loadBalancer, (String)"load balancer");
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("uri", this.uri);
        args.put("expression", (String)this.expression);
        args.put("exchangePattern", (String)this.exchangePattern);
        Processor send = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getProcessorFactory().createProcessor(this.camelContext, "SendDynamicProcessor", args);
        this.processor = AsyncProcessorConverterHelper.convert((Processor)send);
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Object)this.processor);
        ServiceHelper.startService((Object)this.loadBalancer);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.loadBalancer);
        ServiceHelper.stopService((Object)this.processor);
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        Message message = exchange.getIn();
        String serviceName = DefaultServiceCallProcessor.applySimpleLanguage(this.name, exchange);
        String serviceUri = DefaultServiceCallProcessor.applySimpleLanguage(this.uri, exchange);
        String servicePath = DefaultServiceCallProcessor.applySimpleLanguage(this.contextPath, exchange);
        String serviceScheme = DefaultServiceCallProcessor.applySimpleLanguage(this.scheme, exchange);
        message.setHeader("CamelServiceCallUri", (Object)serviceUri);
        message.setHeader("CamelServiceCallContextPath", (Object)servicePath);
        message.setHeader("CamelServiceCallScheme", (Object)serviceScheme);
        message.setHeader("CamelServiceCallServiceName", (Object)serviceName);
        try {
            return (Boolean)this.loadBalancer.process(serviceName, server -> this.execute(server, exchange, callback));
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            return true;
        }
    }

    private boolean execute(ServiceDefinition service, Exchange exchange, AsyncCallback callback) throws Exception {
        Message message = exchange.getIn();
        String host = service.getHost();
        int port = service.getPort();
        Map meta = service.getMetadata();
        LOG.debug("Service {} active at server: {}:{}", new Object[]{this.name, host, port});
        message.setHeader("CamelServiceCallServiceHost", (Object)host);
        message.setHeader("CamelServiceCallServicePort", (Object)(port > 0 ? Integer.valueOf(port) : null));
        message.setHeader("CamelServiceCallServiceName", (Object)service.getName());
        message.setHeader("CamelServiceCallServiceMeta", (Object)meta);
        message.getHeaders().compute("CamelServiceCallContextPath", (k, v) -> v == null ? meta.get("service.path") : v);
        message.getHeaders().compute("CamelServiceCallServicePort", (k, v) -> v == null ? meta.get("service.port") : v);
        return this.processor.process(exchange, callback);
    }

    private static String applySimpleLanguage(String expression, Exchange exchange) {
        if (expression != null) {
            Language simple = exchange.getContext().resolveLanguage("simple");
            return (String)simple.createExpression(expression).evaluate(exchange, String.class);
        }
        return null;
    }
}

