/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.clickup.util;

import jakarta.xml.bind.DatatypeConverter;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.camel.RuntimeCamelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    private static final String HMAC_HASHING_ALGORITHM = "HmacSHA256";

    public static String computeMessageHMAC(String message, String key) {
        try {
            Mac mac = Mac.getInstance(HMAC_HASHING_ALGORITHM);
            mac.init(new SecretKeySpec(key.getBytes(), HMAC_HASHING_ALGORITHM));
            byte[] hash = mac.doFinal(message.getBytes());
            return DatatypeConverter.printHexBinary((byte[])hash);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.debug("This exception should never occur: cannot find the hashing algorithm. {}", (Object)HMAC_HASHING_ALGORITHM);
            throw new RuntimeCamelException((Throwable)e);
        }
        catch (InvalidKeyException e) {
            LOG.debug("This exception should never occur: the provided key is not valid. {}", (Object)key);
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

