/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.clickup.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.camel.component.clickup.model.WebhookHealth;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Webhook
implements Serializable {
    private static final long serialVersionUID = 0L;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="userid")
    private Integer userid = null;
    @JsonProperty(value="team_id")
    private Integer teamId = null;
    @JsonProperty(value="endpoint")
    private String endpoint = null;
    @JsonProperty(value="client_id")
    private String clientId = null;
    @JsonProperty(value="events")
    private Set<String> events = new HashSet<String>();
    @JsonProperty(value="task_id")
    private String taskId = null;
    @JsonProperty(value="list_id")
    private String listId = null;
    @JsonProperty(value="folder_id")
    private String folderId = null;
    @JsonProperty(value="space_id")
    private String spaceId = null;
    @JsonProperty(value="health")
    private WebhookHealth health = null;
    @JsonProperty(value="secret")
    private String secret = null;

    public Integer getUserid() {
        return this.userid;
    }

    public void setUserid(Integer userid) {
        this.userid = userid;
    }

    public Integer getTeamId() {
        return this.teamId;
    }

    public void setTeamId(Integer teamId) {
        this.teamId = teamId;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Set<String> getEvents() {
        return this.events;
    }

    public void setEvents(Set<String> events) {
        this.events = events;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getListId() {
        return this.listId;
    }

    public void setListId(String listId) {
        this.listId = listId;
    }

    public String getFolderId() {
        return this.folderId;
    }

    public void setFolderId(String folderId) {
        this.folderId = folderId;
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    public void setSpaceId(String spaceId) {
        this.spaceId = spaceId;
    }

    public WebhookHealth getHealth() {
        return this.health;
    }

    public void setHealth(WebhookHealth health) {
        this.health = health;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean matchesConfiguration(String endpointUrl, Set<String> events) {
        boolean sameEndpointUrl = this.getEndpoint().equals(endpointUrl);
        boolean sameEvents = Sets.symmetricDifference(this.getEvents(), events).isEmpty();
        return sameEndpointUrl && sameEvents;
    }

    public String toString() {
        return "Webhook{id='" + this.id + "', userid=" + this.userid + ", teamId=" + this.teamId + ", endpoint='" + this.endpoint + "', clientId='" + this.clientId + "', events=" + String.valueOf(this.events) + ", taskId='" + this.taskId + "', listId='" + this.listId + "', folderId='" + this.folderId + "', spaceId='" + this.spaceId + "', health=" + String.valueOf(this.health) + ", secret='" + this.secret + "'}";
    }
}

