/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.camel.cdi.Vetoed;

@Vetoed
final class BeanManagerHelper {
    private BeanManagerHelper() {
    }

    static <T> Set<T> getReferencesByType(BeanManager manager, Class<T> type, Annotation ... qualifiers) {
        HashSet<T> references = new HashSet<T>();
        for (Bean bean : manager.getBeans(type, qualifiers)) {
            references.add(BeanManagerHelper.getReference(manager, type, bean));
        }
        return references;
    }

    static <T> T getReferenceByName(BeanManager manager, String name, Class<T> type) {
        Set beans = manager.getBeans(name);
        if (beans == null || beans.isEmpty()) {
            return null;
        }
        return BeanManagerHelper.getReference(manager, type, manager.resolve(beans));
    }

    static <T> T getReferenceByType(BeanManager manager, Class<T> type, Annotation ... qualifiers) {
        Set beans = manager.getBeans(type, qualifiers);
        if (beans == null || beans.isEmpty()) {
            return null;
        }
        return BeanManagerHelper.getReference(manager, type, manager.resolve(beans));
    }

    static <T> T getReference(BeanManager manager, Class<T> type, Bean<?> bean) {
        return type.cast(manager.getReference(bean, type, manager.createCreationalContext(bean)));
    }
}

