/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterExists;
import org.apache.camel.TypeConverters;
import org.apache.camel.impl.DefaultPackageScanClassResolver;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ServiceHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiTypeConverter
extends ServiceSupport
implements TypeConverter,
TypeConverterRegistry,
ServiceTrackerCustomizer<TypeConverterLoader, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiTypeConverter.class);
    private final BundleContext bundleContext;
    private final CamelContext camelContext;
    private final Injector injector;
    private final FactoryFinder factoryFinder;
    private final ServiceTracker<TypeConverterLoader, Object> tracker;
    private volatile DefaultTypeConverter delegate;

    public OsgiTypeConverter(BundleContext bundleContext, CamelContext camelContext, Injector injector, FactoryFinder factoryFinder) {
        this.bundleContext = bundleContext;
        this.camelContext = camelContext;
        this.injector = injector;
        this.factoryFinder = factoryFinder;
        this.tracker = new ServiceTracker(bundleContext, TypeConverterLoader.class.getName(), (ServiceTrackerCustomizer)this);
    }

    public Object addingService(ServiceReference<TypeConverterLoader> serviceReference) {
        LOG.trace("AddingService: {}, Bundle: {}", serviceReference, (Object)serviceReference.getBundle());
        TypeConverterLoader loader = (TypeConverterLoader)this.bundleContext.getService(serviceReference);
        try {
            LOG.debug("loading type converter from bundle: {}", (Object)serviceReference.getBundle().getSymbolicName());
            if (this.delegate != null) {
                loader.load((TypeConverterRegistry)this.delegate);
            }
        }
        catch (Throwable t) {
            throw new RuntimeCamelException("Error loading type converters from service: " + serviceReference + " due: " + t.getMessage(), t);
        }
        return loader;
    }

    public void modifiedService(ServiceReference<TypeConverterLoader> serviceReference, Object o) {
    }

    public void removedService(ServiceReference<TypeConverterLoader> serviceReference, Object o) {
        LOG.trace("RemovedService: {}, Bundle: {}", serviceReference, (Object)serviceReference.getBundle());
        try {
            ServiceHelper.stopService((Object)this.delegate);
        }
        catch (Exception e) {
            LOG.debug("Error stopping service due: " + e.getMessage() + ". This exception will be ignored.", (Throwable)e);
        }
        this.delegate = null;
    }

    protected void doStart() throws Exception {
        this.tracker.open();
    }

    protected void doStop() throws Exception {
        this.tracker.close();
        ServiceHelper.stopService((Object)this.delegate);
        this.delegate = null;
    }

    public boolean allowNull() {
        return this.getDelegate().allowNull();
    }

    public <T> T convertTo(Class<T> type, Object value) {
        return (T)this.getDelegate().convertTo(type, value);
    }

    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        return (T)this.getDelegate().convertTo(type, exchange, value);
    }

    public <T> T mandatoryConvertTo(Class<T> type, Object value) throws NoTypeConversionAvailableException {
        return (T)this.getDelegate().mandatoryConvertTo(type, value);
    }

    public <T> T mandatoryConvertTo(Class<T> type, Exchange exchange, Object value) throws NoTypeConversionAvailableException {
        return (T)this.getDelegate().mandatoryConvertTo(type, exchange, value);
    }

    public <T> T tryConvertTo(Class<T> type, Exchange exchange, Object value) {
        return (T)this.getDelegate().tryConvertTo(type, exchange, value);
    }

    public <T> T tryConvertTo(Class<T> type, Object value) {
        return (T)this.getDelegate().tryConvertTo(type, value);
    }

    public void addTypeConverter(Class<?> toType, Class<?> fromType, TypeConverter typeConverter) {
        this.getDelegate().addTypeConverter(toType, fromType, typeConverter);
    }

    public void addTypeConverters(TypeConverters typeConverters) {
        this.getDelegate().addTypeConverters(typeConverters);
    }

    public boolean removeTypeConverter(Class<?> toType, Class<?> fromType) {
        return this.getDelegate().removeTypeConverter(toType, fromType);
    }

    public void addFallbackTypeConverter(TypeConverter typeConverter, boolean canPromote) {
        this.getDelegate().addFallbackTypeConverter(typeConverter, canPromote);
    }

    public TypeConverter lookup(Class<?> toType, Class<?> fromType) {
        return this.getDelegate().lookup(toType, fromType);
    }

    public List<Class<?>[]> listAllTypeConvertersFromTo() {
        return this.getDelegate().listAllTypeConvertersFromTo();
    }

    public void setInjector(Injector injector) {
        this.getDelegate().setInjector(injector);
    }

    public Injector getInjector() {
        return this.getDelegate().getInjector();
    }

    public TypeConverterRegistry.Statistics getStatistics() {
        return this.getDelegate().getStatistics();
    }

    public int size() {
        return this.getDelegate().size();
    }

    public LoggingLevel getTypeConverterExistsLoggingLevel() {
        return this.getDelegate().getTypeConverterExistsLoggingLevel();
    }

    public void setTypeConverterExistsLoggingLevel(LoggingLevel loggingLevel) {
        this.getDelegate().setTypeConverterExistsLoggingLevel(loggingLevel);
    }

    public TypeConverterExists getTypeConverterExists() {
        return this.getDelegate().getTypeConverterExists();
    }

    public void setTypeConverterExists(TypeConverterExists typeConverterExists) {
        this.getDelegate().setTypeConverterExists(typeConverterExists);
    }

    public synchronized DefaultTypeConverter getDelegate() {
        if (this.delegate == null) {
            this.delegate = this.createRegistry();
        }
        return this.delegate;
    }

    protected DefaultTypeConverter createRegistry() {
        DefaultTypeConverter answer = new DefaultTypeConverter((PackageScanClassResolver)new DefaultPackageScanClassResolver(){

            public Set<ClassLoader> getClassLoaders() {
                return Collections.emptySet();
            }
        }, this.injector, this.factoryFinder);
        answer.setCamelContext(this.camelContext);
        try {
            answer.loadCoreTypeConverters();
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Error loading CoreTypeConverter due: " + e.getMessage(), (Throwable)e);
        }
        ServiceReference[] serviceReferences = this.tracker.getServiceReferences();
        if (serviceReferences != null) {
            ArrayList<ServiceReference> servicesList = new ArrayList<ServiceReference>(Arrays.asList(serviceReferences));
            Collections.sort(servicesList);
            for (ServiceReference sr : servicesList) {
                try {
                    LOG.debug("loading type converter from bundle: {}", (Object)sr.getBundle().getSymbolicName());
                    ((TypeConverterLoader)this.tracker.getService(sr)).load((TypeConverterRegistry)answer);
                }
                catch (Throwable t) {
                    throw new RuntimeCamelException("Error loading type converters from service: " + sr + " due: " + t.getMessage(), t);
                }
            }
        }
        LOG.trace("Created TypeConverter: {}", (Object)answer);
        return answer;
    }
}

