/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.kvp;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConverter;
import org.apache.camel.dataformat.bindy.BindyAbstractDataFormat;
import org.apache.camel.dataformat.bindy.BindyAbstractFactory;
import org.apache.camel.dataformat.bindy.BindyKeyValuePairFactory;
import org.apache.camel.dataformat.bindy.FormatFactory;
import org.apache.camel.dataformat.bindy.WrappedException;
import org.apache.camel.dataformat.bindy.util.ConverterUtils;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dataformat(value="bindy-kvp")
public class BindyKeyValuePairDataFormat
extends BindyAbstractDataFormat {
    private static final Logger LOG = LoggerFactory.getLogger(BindyKeyValuePairDataFormat.class);

    public BindyKeyValuePairDataFormat() {
    }

    public BindyKeyValuePairDataFormat(Class<?> type) {
        super(type);
    }

    public String getDataFormatName() {
        return "bindy-kvp";
    }

    public void marshal(Exchange exchange, Object body, OutputStream outputStream) throws Exception {
        BindyAbstractFactory factory = this.getFactory();
        byte[] crlf = ConverterUtils.getByteReturn(factory.getCarriageReturn());
        TypeConverter converter = exchange.getContext().getTypeConverter();
        for (Object model : org.apache.camel.support.ObjectHelper.createIterable((Object)body)) {
            Map<String, Object> row = model instanceof Map ? (Map<String, Object>)model : Collections.singletonMap(model.getClass().getName(), model);
            String result = factory.unbind(this.getCamelContext(), row);
            outputStream.write((byte[])converter.convertTo(byte[].class, exchange, (Object)result));
            outputStream.write(crlf);
        }
    }

    /*
     * Loose catch block
     */
    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        BindyKeyValuePairFactory factory = (BindyKeyValuePairFactory)this.getFactory();
        ArrayList<Map<String, Object>> models = new ArrayList<Map<String, Object>>();
        HashMap lists = new HashMap();
        InputStreamReader in = new InputStreamReader(inputStream, ExchangeHelper.getCharsetName((Exchange)exchange));
        try {
            try (Stream<String> lines = new BufferedReader(in).lines();){
                ObjectHelper.notNull((Object)factory.getPairSeparator(), (String)"The pair separator property of the annotation @Message");
                String separator = factory.getPairSeparator();
                AtomicInteger count = new AtomicInteger();
                try {
                    lines.forEachOrdered(line -> this.consumeFile(factory, (List<Map<String, Object>>)models, lists, separator, count, (String)line));
                }
                catch (WrappedException e) {
                    throw e.getWrappedException();
                }
                if (models.isEmpty() && !this.isAllowEmptyStream()) {
                    throw new IllegalArgumentException("No records have been defined in the CSV");
                }
                Object object = this.extractUnmarshalResult(models);
                return object;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IOHelper.close((Closeable)in, (String)"in", (Logger)LOG);
        }
    }

    private void consumeFile(BindyKeyValuePairFactory factory, List<Map<String, Object>> models, Map<String, List<Object>> lists, String separator, AtomicInteger count, String line) {
        try {
            String trimmedLine = line.trim();
            if (!ObjectHelper.isEmpty((Object)trimmedLine)) {
                count.incrementAndGet();
                Map<String, Object> model = factory.factory();
                List<String> result = Arrays.stream(line.split(separator)).map(x -> x.replace("\u0085", "")).collect(Collectors.toList());
                if (result.isEmpty()) {
                    throw new IllegalArgumentException("No records have been defined in the KVP");
                }
                factory.bind(this.getCamelContext(), result, model, count.get(), lists);
                factory.link(model);
                models.add(model);
                LOG.debug("Graph of objects created: {}", model);
            }
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
    }

    @Override
    protected BindyAbstractFactory createModelFactory(FormatFactory formatFactory) throws Exception {
        BindyKeyValuePairFactory bindyKeyValuePairFactory = new BindyKeyValuePairFactory(this.getClassType());
        bindyKeyValuePairFactory.setFormatFactory(formatFactory);
        return bindyKeyValuePairFactory;
    }
}

