/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.format.factories;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Locale;
import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormattingOptions;
import org.apache.camel.dataformat.bindy.format.NumberPatternFormat;
import org.apache.camel.dataformat.bindy.format.factories.AbstractFormatFactory;
import org.apache.camel.util.ObjectHelper;

public class BigDecimalPatternFormatFactory
extends AbstractFormatFactory {
    public BigDecimalPatternFormatFactory() {
        this.supportedClasses.add(BigDecimal.class);
    }

    @Override
    public boolean canBuild(FormattingOptions formattingOptions) {
        return super.canBuild(formattingOptions) && ObjectHelper.isNotEmpty((Object)formattingOptions.getPattern());
    }

    @Override
    public Format<?> build(FormattingOptions formattingOptions) {
        return new BigDecimalPatternFormat(formattingOptions.getPattern(), formattingOptions.getLocale(), formattingOptions.getPrecision(), formattingOptions.getRounding(), formattingOptions.getDecimalSeparator(), formattingOptions.getGroupingSeparator());
    }

    private static class BigDecimalPatternFormat
    extends NumberPatternFormat<BigDecimal> {
        BigDecimalPatternFormat(String pattern, Locale locale, int precision, String rounding, String decimalSeparator, String groupingSeparator) {
            super(pattern, locale, precision, rounding, decimalSeparator, groupingSeparator);
        }

        @Override
        public BigDecimal parse(String string) throws Exception {
            if (this.getNumberFormat() != null) {
                DecimalFormat df = (DecimalFormat)this.getNumberFormat();
                df.setParseBigDecimal(true);
                BigDecimal bd = (BigDecimal)df.parse(string.trim());
                if (super.getPrecision() != -1) {
                    bd = bd.setScale(super.getPrecision(), RoundingMode.valueOf(super.getRounding()));
                }
                return bd;
            }
            return new BigDecimal(string.trim());
        }
    }
}

